@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the Alexa channel.
 * @property alexaSkillId The Alexa skill Id
 * @property isEnabled Whether this channel is enabled for the bot
 * @property serviceEndpointUri Full Uri used to configured the skill in Alexa
 * @property urlFragment Url fragment used in part of the Uri configured in Alexa
 */
public data class AlexaChannelPropertiesResponse(
    public val alexaSkillId: String,
    public val isEnabled: Boolean,
    public val serviceEndpointUri: String,
    public val urlFragment: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.AlexaChannelPropertiesResponse): AlexaChannelPropertiesResponse = AlexaChannelPropertiesResponse(
            alexaSkillId = javaType.alexaSkillId(),
            isEnabled = javaType.isEnabled(),
            serviceEndpointUri = javaType.serviceEndpointUri(),
            urlFragment = javaType.urlFragment(),
        )
    }
}
