@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The parameters to provide for the Bot.
 * @property allSettings Contains resource all settings defined as key/value pairs.
 * @property appPasswordHint The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
 * @property cmekEncryptionStatus The CMK encryption status
 * @property cmekKeyVaultUrl The CMK Url
 * @property configuredChannels Collection of channels for which the bot is configured
 * @property description The description of the bot
 * @property developerAppInsightKey The Application Insights key
 * @property developerAppInsightsApiKey The Application Insights Api Key
 * @property developerAppInsightsApplicationId The Application Insights App Id
 * @property disableLocalAuth Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
 * @property displayName The Name of the bot
 * @property enabledChannels Collection of channels for which the bot is enabled
 * @property endpoint The bot's endpoint
 * @property endpointVersion The bot's endpoint version
 * @property iconUrl The Icon Url of the bot
 * @property isCmekEnabled Whether Cmek is enabled
 * @property isDeveloperAppInsightsApiKeySet Whether the bot is developerAppInsightsApiKey set
 * @property isStreamingSupported Whether the bot is streaming supported
 * @property luisAppIds Collection of LUIS App Ids
 * @property luisKey The LUIS Key
 * @property manifestUrl The bot's manifest url
 * @property migrationToken Token used to migrate non Azure bot to azure subscription
 * @property msaAppId Microsoft App Id for the bot
 * @property msaAppMSIResourceId Microsoft App Managed Identity Resource Id for the bot
 * @property msaAppTenantId Microsoft App Tenant Id for the bot
 * @property msaAppType Microsoft App Type for the bot
 * @property openWithHint The hint to browser (e.g. protocol handler) on how to open the bot for authoring
 * @property parameters Contains resource parameters defined as key/value pairs.
 * @property privateEndpointConnections List of Private Endpoint Connections configured for the bot
 * @property provisioningState Provisioning state of the resource
 * @property publicNetworkAccess Whether the bot is in an isolated network
 * @property publishingCredentials Publishing credentials of the resource
 * @property schemaTransformationVersion The channel schema transformation version for the bot
 * @property storageResourceId The storage resourceId for the bot
 * @property tenantId The Tenant Id for the bot
 */
public data class BotPropertiesResponse(
    public val allSettings: Map<String, String>? = null,
    public val appPasswordHint: String? = null,
    public val cmekEncryptionStatus: String,
    public val cmekKeyVaultUrl: String? = null,
    public val configuredChannels: List<String>,
    public val description: String? = null,
    public val developerAppInsightKey: String? = null,
    public val developerAppInsightsApiKey: String? = null,
    public val developerAppInsightsApplicationId: String? = null,
    public val disableLocalAuth: Boolean? = null,
    public val displayName: String,
    public val enabledChannels: List<String>,
    public val endpoint: String,
    public val endpointVersion: String,
    public val iconUrl: String? = null,
    public val isCmekEnabled: Boolean? = null,
    public val isDeveloperAppInsightsApiKeySet: Boolean,
    public val isStreamingSupported: Boolean? = null,
    public val luisAppIds: List<String>? = null,
    public val luisKey: String? = null,
    public val manifestUrl: String? = null,
    public val migrationToken: String,
    public val msaAppId: String,
    public val msaAppMSIResourceId: String? = null,
    public val msaAppTenantId: String? = null,
    public val msaAppType: String? = null,
    public val openWithHint: String? = null,
    public val parameters: Map<String, String>? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val publishingCredentials: String? = null,
    public val schemaTransformationVersion: String? = null,
    public val storageResourceId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.BotPropertiesResponse): BotPropertiesResponse = BotPropertiesResponse(
            allSettings = javaType.allSettings().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            appPasswordHint = javaType.appPasswordHint().map({ args0 -> args0 }).orElse(null),
            cmekEncryptionStatus = javaType.cmekEncryptionStatus(),
            cmekKeyVaultUrl = javaType.cmekKeyVaultUrl().map({ args0 -> args0 }).orElse(null),
            configuredChannels = javaType.configuredChannels().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            developerAppInsightKey = javaType.developerAppInsightKey().map({ args0 -> args0 }).orElse(null),
            developerAppInsightsApiKey = javaType.developerAppInsightsApiKey().map({ args0 ->
                args0
            }).orElse(null),
            developerAppInsightsApplicationId = javaType.developerAppInsightsApplicationId().map({ args0 ->
                args0
            }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            enabledChannels = javaType.enabledChannels().map({ args0 -> args0 }),
            endpoint = javaType.endpoint(),
            endpointVersion = javaType.endpointVersion(),
            iconUrl = javaType.iconUrl().map({ args0 -> args0 }).orElse(null),
            isCmekEnabled = javaType.isCmekEnabled().map({ args0 -> args0 }).orElse(null),
            isDeveloperAppInsightsApiKeySet = javaType.isDeveloperAppInsightsApiKeySet(),
            isStreamingSupported = javaType.isStreamingSupported().map({ args0 -> args0 }).orElse(null),
            luisAppIds = javaType.luisAppIds().map({ args0 -> args0 }),
            luisKey = javaType.luisKey().map({ args0 -> args0 }).orElse(null),
            manifestUrl = javaType.manifestUrl().map({ args0 -> args0 }).orElse(null),
            migrationToken = javaType.migrationToken(),
            msaAppId = javaType.msaAppId(),
            msaAppMSIResourceId = javaType.msaAppMSIResourceId().map({ args0 -> args0 }).orElse(null),
            msaAppTenantId = javaType.msaAppTenantId().map({ args0 -> args0 }).orElse(null),
            msaAppType = javaType.msaAppType().map({ args0 -> args0 }).orElse(null),
            openWithHint = javaType.openWithHint().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            publishingCredentials = javaType.publishingCredentials().map({ args0 -> args0 }).orElse(null),
            schemaTransformationVersion = javaType.schemaTransformationVersion().map({ args0 ->
                args0
            }).orElse(null),
            storageResourceId = javaType.storageResourceId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
