@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Channel settings definition
 * @property botIconUrl The bot icon url
 * @property botId The bot id
 * @property channelDisplayName The channel display name
 * @property channelId The channel id
 * @property disableLocalAuth Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
 * @property extensionKey1 The extensionKey1
 * @property extensionKey2 The extensionKey2
 * @property isEnabled Whether this channel is enabled for the bot
 * @property requireTermsAgreement Whether customer needs to agree to new terms.
 * @property sites The list of sites
 */
public data class ChannelSettingsResponse(
    public val botIconUrl: String? = null,
    public val botId: String? = null,
    public val channelDisplayName: String? = null,
    public val channelId: String? = null,
    public val disableLocalAuth: Boolean? = null,
    public val extensionKey1: String? = null,
    public val extensionKey2: String? = null,
    public val isEnabled: Boolean? = null,
    public val requireTermsAgreement: Boolean? = null,
    public val sites: List<SiteResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.ChannelSettingsResponse): ChannelSettingsResponse = ChannelSettingsResponse(
            botIconUrl = javaType.botIconUrl().map({ args0 -> args0 }).orElse(null),
            botId = javaType.botId().map({ args0 -> args0 }).orElse(null),
            channelDisplayName = javaType.channelDisplayName().map({ args0 -> args0 }).orElse(null),
            channelId = javaType.channelId().map({ args0 -> args0 }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            extensionKey1 = javaType.extensionKey1().map({ args0 -> args0 }).orElse(null),
            extensionKey2 = javaType.extensionKey2().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            requireTermsAgreement = javaType.requireTermsAgreement().map({ args0 -> args0 }).orElse(null),
            sites = javaType.sites().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.SiteResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
