@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties for a Connection Setting Item
 * @property clientId Client Id associated with the Connection Setting.
 * @property clientSecret Client Secret associated with the Connection Setting
 * @property id Id of the Connection Setting.
 * @property name Name of the Connection Setting.
 * @property parameters Service Provider Parameters associated with the Connection Setting
 * @property provisioningState Provisioning state of the resource
 * @property scopes Scopes associated with the Connection Setting
 * @property serviceProviderDisplayName Service Provider Display Name associated with the Connection Setting
 * @property serviceProviderId Service Provider Id associated with the Connection Setting
 * @property settingId Setting Id set by the service for the Connection Setting.
 */
public data class ConnectionSettingPropertiesResponse(
    public val clientId: String? = null,
    public val clientSecret: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val parameters: List<ConnectionSettingParameterResponse>? = null,
    public val provisioningState: String? = null,
    public val scopes: String? = null,
    public val serviceProviderDisplayName: String? = null,
    public val serviceProviderId: String? = null,
    public val settingId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.ConnectionSettingPropertiesResponse): ConnectionSettingPropertiesResponse = ConnectionSettingPropertiesResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.ConnectionSettingParameterResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            scopes = javaType.scopes().map({ args0 -> args0 }).orElse(null),
            serviceProviderDisplayName = javaType.serviceProviderDisplayName().map({ args0 ->
                args0
            }).orElse(null),
            serviceProviderId = javaType.serviceProviderId().map({ args0 -> args0 }).orElse(null),
            settingId = javaType.settingId(),
        )
    }
}
