@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A site for the Direct Line channel
 * @property appId DirectLine application id
 * @property eTag Entity Tag
 * @property isBlockUserUploadEnabled Whether this site is enabled for block user upload.
 * @property isDetailedLoggingEnabled Whether this site is disabled detailed logging for
 * @property isEnabled Whether this site is enabled for DirectLine channel
 * @property isEndpointParametersEnabled Whether this site is EndpointParameters enabled for channel
 * @property isNoStorageEnabled Whether this no-storage site is disabled detailed logging for
 * @property isSecureSiteEnabled Whether this site is enabled for authentication with Bot Framework.
 * @property isTokenEnabled Whether this site is token enabled for channel
 * @property isV1Enabled Whether this site is enabled for Bot Framework V1 protocol.
 * @property isV3Enabled Whether this site is enabled for Bot Framework V3 protocol.
 * @property isWebChatSpeechEnabled Whether this site is enabled for Webchat Speech
 * @property isWebchatPreviewEnabled Whether this site is enabled for preview versions of Webchat
 * @property key Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property key2 Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property siteId Site Id
 * @property siteName Site name
 * @property tenantId Tenant Id
 * @property trustedOrigins List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
 */
public data class DirectLineSiteResponse(
    public val appId: String? = null,
    public val eTag: String? = null,
    public val isBlockUserUploadEnabled: Boolean? = null,
    public val isDetailedLoggingEnabled: Boolean? = null,
    public val isEnabled: Boolean,
    public val isEndpointParametersEnabled: Boolean? = null,
    public val isNoStorageEnabled: Boolean? = null,
    public val isSecureSiteEnabled: Boolean? = null,
    public val isTokenEnabled: Boolean,
    public val isV1Enabled: Boolean,
    public val isV3Enabled: Boolean,
    public val isWebChatSpeechEnabled: Boolean? = null,
    public val isWebchatPreviewEnabled: Boolean? = null,
    public val key: String,
    public val key2: String,
    public val siteId: String,
    public val siteName: String,
    public val tenantId: String? = null,
    public val trustedOrigins: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.DirectLineSiteResponse): DirectLineSiteResponse = DirectLineSiteResponse(
            appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            isBlockUserUploadEnabled = javaType.isBlockUserUploadEnabled().map({ args0 -> args0 }).orElse(null),
            isDetailedLoggingEnabled = javaType.isDetailedLoggingEnabled().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled(),
            isEndpointParametersEnabled = javaType.isEndpointParametersEnabled().map({ args0 ->
                args0
            }).orElse(null),
            isNoStorageEnabled = javaType.isNoStorageEnabled().map({ args0 -> args0 }).orElse(null),
            isSecureSiteEnabled = javaType.isSecureSiteEnabled().map({ args0 -> args0 }).orElse(null),
            isTokenEnabled = javaType.isTokenEnabled(),
            isV1Enabled = javaType.isV1Enabled(),
            isV3Enabled = javaType.isV3Enabled(),
            isWebChatSpeechEnabled = javaType.isWebChatSpeechEnabled().map({ args0 -> args0 }).orElse(null),
            isWebchatPreviewEnabled = javaType.isWebchatPreviewEnabled().map({ args0 -> args0 }).orElse(null),
            key = javaType.key(),
            key2 = javaType.key2(),
            siteId = javaType.siteId(),
            siteName = javaType.siteName(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            trustedOrigins = javaType.trustedOrigins().map({ args0 -> args0 }),
        )
    }
}
