@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The parameters to provide for the Facebook channel.
 * @property appId Facebook application id
 * @property appSecret Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property callbackUrl Callback Url
 * @property isEnabled Whether this channel is enabled for the bot
 * @property pages The list of Facebook pages
 * @property verifyToken Verify token. Value only returned through POST to the action Channel List API, otherwise empty.
 */
public data class FacebookChannelPropertiesResponse(
    public val appId: String,
    public val appSecret: String? = null,
    public val callbackUrl: String,
    public val isEnabled: Boolean,
    public val pages: List<FacebookPageResponse>? = null,
    public val verifyToken: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.FacebookChannelPropertiesResponse): FacebookChannelPropertiesResponse = FacebookChannelPropertiesResponse(
            appId = javaType.appId(),
            appSecret = javaType.appSecret().map({ args0 -> args0 }).orElse(null),
            callbackUrl = javaType.callbackUrl(),
            isEnabled = javaType.isEnabled(),
            pages = javaType.pages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.FacebookPageResponse.Companion.toKotlin(args0)
                })
            }),
            verifyToken = javaType.verifyToken(),
        )
    }
}
