@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the Kik channel.
 * @property apiKey Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property isEnabled Whether this channel is enabled for the bot
 * @property isValidated Whether this channel is validated for the bot
 * @property userName The Kik user name
 */
public data class KikChannelPropertiesResponse(
    public val apiKey: String? = null,
    public val isEnabled: Boolean,
    public val isValidated: Boolean? = null,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.KikChannelPropertiesResponse): KikChannelPropertiesResponse = KikChannelPropertiesResponse(
            apiKey = javaType.apiKey().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled(),
            isValidated = javaType.isValidated().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName(),
        )
    }
}
