@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties corresponding to a line channel registration
 * @property channelAccessToken Access token for the line channel registration
 * @property channelSecret Secret for the line channel registration
 * @property generatedId Id generated for the line channel registration
 */
public data class LineRegistrationResponse(
    public val channelAccessToken: String? = null,
    public val channelSecret: String? = null,
    public val generatedId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.LineRegistrationResponse): LineRegistrationResponse = LineRegistrationResponse(
            channelAccessToken = javaType.channelAccessToken().map({ args0 -> args0 }).orElse(null),
            channelSecret = javaType.channelSecret().map({ args0 -> args0 }).orElse(null),
            generatedId = javaType.generatedId(),
        )
    }
}
