@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The list of bot service providers response.
 * @property nextLink The link used to get the next page of bot service providers.
 * @property value Gets the list of bot service providers and their properties.
 */
public data class ListBotConnectionServiceProvidersResult(
    public val nextLink: String? = null,
    public val `value`: List<ServiceProviderResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.ListBotConnectionServiceProvidersResult): ListBotConnectionServiceProvidersResult = ListBotConnectionServiceProvidersResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.ServiceProviderResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
