@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Schema for EndpointKeys generate/refresh operations.
 * @property installedVersion Current version of runtime.
 * @property lastStableVersion Latest version of runtime.
 * @property primaryEndpointKey Primary Access Key.
 * @property secondaryEndpointKey Secondary Access Key.
 */
public data class ListQnAMakerEndpointKeyResult(
    public val installedVersion: String? = null,
    public val lastStableVersion: String? = null,
    public val primaryEndpointKey: String? = null,
    public val secondaryEndpointKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.ListQnAMakerEndpointKeyResult): ListQnAMakerEndpointKeyResult = ListQnAMakerEndpointKeyResult(
            installedVersion = javaType.installedVersion().map({ args0 -> args0 }).orElse(null),
            lastStableVersion = javaType.lastStableVersion().map({ args0 -> args0 }).orElse(null),
            primaryEndpointKey = javaType.primaryEndpointKey().map({ args0 -> args0 }).orElse(null),
            secondaryEndpointKey = javaType.secondaryEndpointKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
