@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the Microsoft Teams channel.
 * @property acceptedTerms Whether this channel accepted terms
 * @property callingWebhook Webhook for Microsoft Teams channel calls
 * @property deploymentEnvironment Deployment environment for Microsoft Teams channel calls
 * @property enableCalling Enable calling for Microsoft Teams channel
 * @property incomingCallRoute Webhook for Microsoft Teams channel calls
 * @property isEnabled Whether this channel is enabled for the bot
 */
public data class MsTeamsChannelPropertiesResponse(
    public val acceptedTerms: Boolean? = null,
    public val callingWebhook: String? = null,
    public val deploymentEnvironment: String? = null,
    public val enableCalling: Boolean? = null,
    public val incomingCallRoute: String? = null,
    public val isEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.MsTeamsChannelPropertiesResponse): MsTeamsChannelPropertiesResponse = MsTeamsChannelPropertiesResponse(
            acceptedTerms = javaType.acceptedTerms().map({ args0 -> args0 }).orElse(null),
            callingWebhook = javaType.callingWebhook().map({ args0 -> args0 }).orElse(null),
            deploymentEnvironment = javaType.deploymentEnvironment().map({ args0 -> args0 }).orElse(null),
            enableCalling = javaType.enableCalling().map({ args0 -> args0 }).orElse(null),
            incomingCallRoute = javaType.incomingCallRoute().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled(),
        )
    }
}
