@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Microsoft Teams channel definition
 * @property channelName The channel name
 * Expected value is 'MsTeamsChannel'.
 * @property etag Entity Tag of the resource
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to Microsoft Teams channel resource
 * @property provisioningState Provisioning state of the resource
 */
public data class MsTeamsChannelResponse(
    public val channelName: String,
    public val etag: String? = null,
    public val location: String? = null,
    public val properties: MsTeamsChannelPropertiesResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.MsTeamsChannelResponse): MsTeamsChannelResponse = MsTeamsChannelResponse(
            channelName = javaType.channelName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.MsTeamsChannelPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
