@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Extra Parameters specific to each Service Provider
 * @property default Default Name for the Service Provider
 * @property description Description of the Service Provider
 * @property displayName Display Name of the Service Provider
 * @property helpUrl Help Url for the  Service Provider
 * @property metadata Meta data for the Service Provider
 * @property name Name of the Service Provider
 * @property type Type of the Service Provider
 */
public data class ServiceProviderParameterResponse(
    public val default: String,
    public val description: String,
    public val displayName: String,
    public val helpUrl: String,
    public val metadata: ServiceProviderParameterResponseMetadata,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.ServiceProviderParameterResponse): ServiceProviderParameterResponse = ServiceProviderParameterResponse(
            default = javaType.default_(),
            description = javaType.description(),
            displayName = javaType.displayName(),
            helpUrl = javaType.helpUrl(),
            metadata = javaType.metadata().let({ args0 ->
                com.pulumi.azurenative.botservice.kotlin.outputs.ServiceProviderParameterResponseMetadata.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
