@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the Slack channel.
 * @property clientId The Slack client id
 * @property clientSecret The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property isEnabled Whether this channel is enabled for the bot
 * @property isValidated Whether this channel is validated for the bot
 * @property landingPageUrl The Slack landing page Url
 * @property lastSubmissionId The Sms auth token
 * @property redirectAction The Slack redirect action
 * @property registerBeforeOAuthFlow Whether to register the settings before OAuth validation is performed. Recommended to True.
 * @property scopes The Slack permission scopes.
 * @property signingSecret The Slack signing secret.
 * @property verificationToken The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
 */
public data class SlackChannelPropertiesResponse(
    public val clientId: String? = null,
    public val clientSecret: String? = null,
    public val isEnabled: Boolean,
    public val isValidated: Boolean,
    public val landingPageUrl: String? = null,
    public val lastSubmissionId: String,
    public val redirectAction: String,
    public val registerBeforeOAuthFlow: Boolean? = null,
    public val scopes: String? = null,
    public val signingSecret: String? = null,
    public val verificationToken: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.SlackChannelPropertiesResponse): SlackChannelPropertiesResponse = SlackChannelPropertiesResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled(),
            isValidated = javaType.isValidated(),
            landingPageUrl = javaType.landingPageUrl().map({ args0 -> args0 }).orElse(null),
            lastSubmissionId = javaType.lastSubmissionId(),
            redirectAction = javaType.redirectAction(),
            registerBeforeOAuthFlow = javaType.registerBeforeOAuthFlow().map({ args0 -> args0 }).orElse(null),
            scopes = javaType.scopes().map({ args0 -> args0 }).orElse(null),
            signingSecret = javaType.signingSecret().map({ args0 -> args0 }).orElse(null),
            verificationToken = javaType.verificationToken().map({ args0 -> args0 }).orElse(null),
        )
    }
}
