@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the Telegram channel.
 * @property accessToken The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property isEnabled Whether this channel is enabled for the bot
 * @property isValidated Whether this channel is validated for the bot
 */
public data class TelegramChannelPropertiesResponse(
    public val accessToken: String? = null,
    public val isEnabled: Boolean,
    public val isValidated: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.TelegramChannelPropertiesResponse): TelegramChannelPropertiesResponse = TelegramChannelPropertiesResponse(
            accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled(),
            isValidated = javaType.isValidated().map({ args0 -> args0 }).orElse(null),
        )
    }
}
