@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The parameters to provide for the Web Chat channel.
 * @property sites The list of Web Chat sites
 * @property webChatEmbedCode Web chat control embed code
 */
public data class WebChatChannelPropertiesResponse(
    public val sites: List<WebChatSiteResponse>? = null,
    public val webChatEmbedCode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.WebChatChannelPropertiesResponse): WebChatChannelPropertiesResponse = WebChatChannelPropertiesResponse(
            sites = javaType.sites().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.botservice.kotlin.outputs.WebChatSiteResponse.Companion.toKotlin(args0)
                })
            }),
            webChatEmbedCode = javaType.webChatEmbedCode(),
        )
    }
}
