@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessPolicy].
 */
@PulumiTagMarker
public class AccessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPolicyArgs = AccessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPolicyArgsBuilder.() -> Unit) {
        val builder = AccessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessPolicy {
        val builtJavaResource = com.pulumi.azurenative.cache.AccessPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessPolicy(builtJavaResource)
    }
}

/**
 * Response to get/put access policy.
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-08-01, 2024-03-01, 2024-04-01-preview.
 * ## Example Usage
 * ### RedisCacheAccessPolicyCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessPolicy = new AzureNative.Cache.AccessPolicy("accessPolicy", new()
 *     {
 *         AccessPolicyName = "accessPolicy1",
 *         CacheName = "cache1",
 *         Permissions = "+get +hget",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewAccessPolicy(ctx, "accessPolicy", &cache.AccessPolicyArgs{
 * 			AccessPolicyName:  pulumi.String("accessPolicy1"),
 * 			CacheName:         pulumi.String("cache1"),
 * 			Permissions:       pulumi.String("+get +hget"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.AccessPolicy;
 * import com.pulumi.azurenative.cache.AccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessPolicy = new AccessPolicy("accessPolicy", AccessPolicyArgs.builder()
 *             .accessPolicyName("accessPolicy1")
 *             .cacheName("cache1")
 *             .permissions("+get +hget")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:AccessPolicy accessPolicy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicies/{accessPolicyName}
 * ```
 */
public class AccessPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.cache.AccessPolicy,
) : KotlinCustomResource(javaResource, AccessPolicyMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Permissions for the access policy. Learn how to configure permissions at https://aka.ms/redis/AADPreRequisites
     */
    public val permissions: Output<String>
        get() = javaResource.permissions().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of access policy
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccessPolicyMapper : ResourceMapper<AccessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cache.AccessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AccessPolicy = AccessPolicy(
        javaResource as
            com.pulumi.azurenative.cache.AccessPolicy,
    )
}

/**
 * @see [AccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPolicy].
 */
public suspend fun accessPolicy(
    name: String,
    block: suspend AccessPolicyResourceBuilder.() -> Unit,
): AccessPolicy {
    val builder = AccessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPolicy(name: String): AccessPolicy {
    val builder = AccessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
