@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LinkedServer].
 */
@PulumiTagMarker
public class LinkedServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkedServerArgs = LinkedServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkedServerArgsBuilder.() -> Unit) {
        val builder = LinkedServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LinkedServer {
        val builtJavaResource = com.pulumi.azurenative.cache.LinkedServer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LinkedServer(builtJavaResource)
    }
}

/**
 * Response to put/get linked server (with properties) for Redis cache.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2023-05-01-preview, 2023-08-01, 2024-03-01, 2024-04-01-preview.
 * ## Example Usage
 * ### LinkedServer_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedServer = new AzureNative.Cache.LinkedServer("linkedServer", new()
 *     {
 *         LinkedRedisCacheId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache2",
 *         LinkedRedisCacheLocation = "West US",
 *         LinkedServerName = "cache2",
 *         Name = "cache1",
 *         ResourceGroupName = "rg1",
 *         ServerRole = AzureNative.Cache.ReplicationRole.Secondary,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewLinkedServer(ctx, "linkedServer", &cache.LinkedServerArgs{
 * 			LinkedRedisCacheId:       pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache2"),
 * 			LinkedRedisCacheLocation: pulumi.String("West US"),
 * 			LinkedServerName:         pulumi.String("cache2"),
 * 			Name:                     pulumi.String("cache1"),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 			ServerRole:               cache.ReplicationRoleSecondary,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.LinkedServer;
 * import com.pulumi.azurenative.cache.LinkedServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedServer = new LinkedServer("linkedServer", LinkedServerArgs.builder()
 *             .linkedRedisCacheId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache2")
 *             .linkedRedisCacheLocation("West US")
 *             .linkedServerName("cache2")
 *             .name("cache1")
 *             .resourceGroupName("rg1")
 *             .serverRole("Secondary")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:LinkedServer cache2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{name}/linkedServers/{linkedServerName}
 * ```
 */
public class LinkedServer internal constructor(
    override val javaResource: com.pulumi.azurenative.cache.LinkedServer,
) : KotlinCustomResource(javaResource, LinkedServerMapper) {
    /**
     * The unchanging DNS name which will always point to current geo-primary cache among the linked redis caches for seamless Geo Failover experience.
     */
    public val geoReplicatedPrimaryHostName: Output<String>
        get() = javaResource.geoReplicatedPrimaryHostName().applyValue({ args0 -> args0 })

    /**
     * Fully qualified resourceId of the linked redis cache.
     */
    public val linkedRedisCacheId: Output<String>
        get() = javaResource.linkedRedisCacheId().applyValue({ args0 -> args0 })

    /**
     * Location of the linked redis cache.
     */
    public val linkedRedisCacheLocation: Output<String>
        get() = javaResource.linkedRedisCacheLocation().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The changing DNS name that resolves to the current geo-primary cache among the linked redis caches before or after the Geo Failover.
     */
    public val primaryHostName: Output<String>
        get() = javaResource.primaryHostName().applyValue({ args0 -> args0 })

    /**
     * Terminal state of the link between primary and secondary redis cache.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Role of the linked server.
     */
    public val serverRole: Output<String>
        get() = javaResource.serverRole().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LinkedServerMapper : ResourceMapper<LinkedServer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cache.LinkedServer::class == javaResource::class

    override fun map(javaResource: Resource): LinkedServer = LinkedServer(
        javaResource as
            com.pulumi.azurenative.cache.LinkedServer,
    )
}

/**
 * @see [LinkedServer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkedServer].
 */
public suspend fun linkedServer(
    name: String,
    block: suspend LinkedServerResourceBuilder.() -> Unit,
): LinkedServer {
    val builder = LinkedServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkedServer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkedServer(name: String): LinkedServer {
    val builder = LinkedServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
