@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.PatchScheduleArgs.builder
import com.pulumi.azurenative.cache.kotlin.inputs.ScheduleEntryArgs
import com.pulumi.azurenative.cache.kotlin.inputs.ScheduleEntryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Response to put/get patch schedules for Redis cache.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2023-05-01-preview, 2023-08-01, 2024-03-01, 2024-04-01-preview.
 * ## Example Usage
 * ### RedisCachePatchSchedulesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var patchSchedule = new AzureNative.Cache.PatchSchedule("patchSchedule", new()
 *     {
 *         Default = "default",
 *         Name = "cache1",
 *         ResourceGroupName = "rg1",
 *         ScheduleEntries = new[]
 *         {
 *             new AzureNative.Cache.Inputs.ScheduleEntryArgs
 *             {
 *                 DayOfWeek = AzureNative.Cache.DayOfWeek.Monday,
 *                 MaintenanceWindow = "PT5H",
 *                 StartHourUtc = 12,
 *             },
 *             new AzureNative.Cache.Inputs.ScheduleEntryArgs
 *             {
 *                 DayOfWeek = AzureNative.Cache.DayOfWeek.Tuesday,
 *                 StartHourUtc = 12,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewPatchSchedule(ctx, "patchSchedule", &cache.PatchScheduleArgs{
 * 			Default:           pulumi.String("default"),
 * 			Name:              pulumi.String("cache1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ScheduleEntries: cache.ScheduleEntryArray{
 * 				&cache.ScheduleEntryArgs{
 * 					DayOfWeek:         cache.DayOfWeekMonday,
 * 					MaintenanceWindow: pulumi.String("PT5H"),
 * 					StartHourUtc:      pulumi.Int(12),
 * 				},
 * 				&cache.ScheduleEntryArgs{
 * 					DayOfWeek:    cache.DayOfWeekTuesday,
 * 					StartHourUtc: pulumi.Int(12),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.PatchSchedule;
 * import com.pulumi.azurenative.cache.PatchScheduleArgs;
 * import com.pulumi.azurenative.cache.inputs.ScheduleEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var patchSchedule = new PatchSchedule("patchSchedule", PatchScheduleArgs.builder()
 *             .default_("default")
 *             .name("cache1")
 *             .resourceGroupName("rg1")
 *             .scheduleEntries(
 *                 ScheduleEntryArgs.builder()
 *                     .dayOfWeek("Monday")
 *                     .maintenanceWindow("PT5H")
 *                     .startHourUtc(12)
 *                     .build(),
 *                 ScheduleEntryArgs.builder()
 *                     .dayOfWeek("Tuesday")
 *                     .startHourUtc(12)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:PatchSchedule cachename1/default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{name}/patchSchedules/{default}
 * ```
 * @property default Default string modeled as parameter for auto generation to work correctly.
 * @property name The name of the Redis cache.
 * @property resourceGroupName The name of the resource group.
 * @property scheduleEntries List of patch schedules for a Redis cache.
 */
public data class PatchScheduleArgs(
    public val default: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scheduleEntries: Output<List<ScheduleEntryArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.PatchScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.PatchScheduleArgs =
        com.pulumi.azurenative.cache.PatchScheduleArgs.builder()
            .default_(default?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scheduleEntries(
                scheduleEntries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PatchScheduleArgs].
 */
@PulumiTagMarker
public class PatchScheduleArgsBuilder internal constructor() {
    private var default: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scheduleEntries: Output<List<ScheduleEntryArgs>>? = null

    /**
     * @param value Default string modeled as parameter for auto generation to work correctly.
     */
    @JvmName("benrhhbugrkexkgo")
    public suspend fun default(`value`: Output<String>) {
        this.default = value
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("gjwjtamkxqdqtouy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rfxxtqcxxvmbeuqr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of patch schedules for a Redis cache.
     */
    @JvmName("ywhqvuunrxlgcfev")
    public suspend fun scheduleEntries(`value`: Output<List<ScheduleEntryArgs>>) {
        this.scheduleEntries = value
    }

    @JvmName("npkgmqbfnhyckvlv")
    public suspend fun scheduleEntries(vararg values: Output<ScheduleEntryArgs>) {
        this.scheduleEntries = Output.all(values.asList())
    }

    /**
     * @param values List of patch schedules for a Redis cache.
     */
    @JvmName("syyprehluitchdig")
    public suspend fun scheduleEntries(values: List<Output<ScheduleEntryArgs>>) {
        this.scheduleEntries = Output.all(values)
    }

    /**
     * @param value Default string modeled as parameter for auto generation to work correctly.
     */
    @JvmName("kixiwgjoknssqqyb")
    public suspend fun default(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("suvcdvmovjysthyh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("igjycipqnhugbqgl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of patch schedules for a Redis cache.
     */
    @JvmName("kafmcoagngugsgtl")
    public suspend fun scheduleEntries(`value`: List<ScheduleEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleEntries = mapped
    }

    /**
     * @param argument List of patch schedules for a Redis cache.
     */
    @JvmName("ilqwvabjpyocqcrm")
    public suspend fun scheduleEntries(argument: List<suspend ScheduleEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleEntryArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scheduleEntries = mapped
    }

    /**
     * @param argument List of patch schedules for a Redis cache.
     */
    @JvmName("hehyusqsvtrsdtyg")
    public suspend fun scheduleEntries(vararg argument: suspend ScheduleEntryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScheduleEntryArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scheduleEntries = mapped
    }

    /**
     * @param argument List of patch schedules for a Redis cache.
     */
    @JvmName("pjwmxlqevpgayycf")
    public suspend fun scheduleEntries(argument: suspend ScheduleEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScheduleEntryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scheduleEntries = mapped
    }

    /**
     * @param values List of patch schedules for a Redis cache.
     */
    @JvmName("otpavlrkhuiryplo")
    public suspend fun scheduleEntries(vararg values: ScheduleEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleEntries = mapped
    }

    internal fun build(): PatchScheduleArgs = PatchScheduleArgs(
        default = default,
        name = name,
        resourceGroupName = resourceGroupName,
        scheduleEntries = scheduleEntries,
    )
}
