@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.kotlin.outputs.ClusterPropertiesResponseEncryption
import com.pulumi.azurenative.cache.kotlin.outputs.EnterpriseSkuResponse
import com.pulumi.azurenative.cache.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.cache.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.cache.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.cache.kotlin.outputs.ClusterPropertiesResponseEncryption.Companion.toKotlin as clusterPropertiesResponseEncryptionToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.EnterpriseSkuResponse.Companion.toKotlin as enterpriseSkuResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.cache.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RedisEnterprise].
 */
@PulumiTagMarker
public class RedisEnterpriseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RedisEnterpriseArgs = RedisEnterpriseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RedisEnterpriseArgsBuilder.() -> Unit) {
        val builder = RedisEnterpriseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RedisEnterprise {
        val builtJavaResource = com.pulumi.azurenative.cache.RedisEnterprise(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RedisEnterprise(builtJavaResource)
    }
}

/**
 * Describes the RedisEnterprise cluster
 * Azure REST API version: 2023-03-01-preview. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2020-10-01-preview, 2023-07-01, 2023-08-01-preview, 2023-10-01-preview, 2023-11-01, 2024-02-01, 2024-03-01-preview, 2024-06-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:RedisEnterprise cache1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}
 * ```
 */
public class RedisEnterprise internal constructor(
    override val javaResource: com.pulumi.azurenative.cache.RedisEnterprise,
) : KotlinCustomResource(javaResource, RedisEnterpriseMapper) {
    /**
     * Encryption-at-rest configuration for the cluster.
     */
    public val encryption: Output<ClusterPropertiesResponseEncryption>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterPropertiesResponseEncryptionToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * DNS name of the cluster endpoint
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * The identity of the resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    public val minimumTlsVersion: Output<String>?
        get() = javaResource.minimumTlsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connections associated with the specified RedisEnterprise cluster
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Current provisioning status of the cluster
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Version of redis the cluster supports, e.g. '6'
     */
    public val redisVersion: Output<String>
        get() = javaResource.redisVersion().applyValue({ args0 -> args0 })

    /**
     * Current resource status of the cluster
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * The SKU to create, which affects price, performance, and features.
     */
    public val sku: Output<EnterpriseSkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                enterpriseSkuResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The Availability Zones where this cluster will be deployed.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object RedisEnterpriseMapper : ResourceMapper<RedisEnterprise> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cache.RedisEnterprise::class == javaResource::class

    override fun map(javaResource: Resource): RedisEnterprise = RedisEnterprise(
        javaResource as
            com.pulumi.azurenative.cache.RedisEnterprise,
    )
}

/**
 * @see [RedisEnterprise].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RedisEnterprise].
 */
public suspend fun redisEnterprise(
    name: String,
    block: suspend RedisEnterpriseResourceBuilder.() -> Unit,
): RedisEnterprise {
    val builder = RedisEnterpriseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RedisEnterprise].
 * @param name The _unique_ name of the resulting resource.
 */
public fun redisEnterprise(name: String): RedisEnterprise {
    val builder = RedisEnterpriseResourceBuilder()
    builder.name(name)
    return builder.build()
}
