@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Redis eviction policy - default is VolatileLRU
 */
public enum class EvictionPolicy(
    public val javaValue: com.pulumi.azurenative.cache.enums.EvictionPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.cache.enums.EvictionPolicy> {
    AllKeysLFU(com.pulumi.azurenative.cache.enums.EvictionPolicy.AllKeysLFU),
    AllKeysLRU(com.pulumi.azurenative.cache.enums.EvictionPolicy.AllKeysLRU),
    AllKeysRandom(com.pulumi.azurenative.cache.enums.EvictionPolicy.AllKeysRandom),
    VolatileLRU(com.pulumi.azurenative.cache.enums.EvictionPolicy.VolatileLRU),
    VolatileLFU(com.pulumi.azurenative.cache.enums.EvictionPolicy.VolatileLFU),
    VolatileTTL(com.pulumi.azurenative.cache.enums.EvictionPolicy.VolatileTTL),
    VolatileRandom(com.pulumi.azurenative.cache.enums.EvictionPolicy.VolatileRandom),
    NoEviction(com.pulumi.azurenative.cache.enums.EvictionPolicy.NoEviction),
    ;

    override fun toJava(): com.pulumi.azurenative.cache.enums.EvictionPolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.enums.EvictionPolicy): EvictionPolicy = EvictionPolicy.values().first { it.javaValue == javaType }
    }
}
