@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.GetAccessPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessPolicyName The name of the access policy that is being added to the Redis cache.
 * @property cacheName The name of the Redis cache.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAccessPolicyPlainArgs(
    public val accessPolicyName: String,
    public val cacheName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.GetAccessPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.GetAccessPolicyPlainArgs =
        com.pulumi.azurenative.cache.inputs.GetAccessPolicyPlainArgs.builder()
            .accessPolicyName(accessPolicyName.let({ args0 -> args0 }))
            .cacheName(cacheName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetAccessPolicyPlainArgsBuilder internal constructor() {
    private var accessPolicyName: String? = null

    private var cacheName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the access policy that is being added to the Redis cache.
     */
    @JvmName("xifoajrmftruostv")
    public suspend fun accessPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessPolicyName = mapped
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("hdbpqqcvljoeeeur")
    public suspend fun cacheName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cacheName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jueutyxvvxvblgdb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccessPolicyPlainArgs = GetAccessPolicyPlainArgs(
        accessPolicyName = accessPolicyName ?: throw PulumiNullFieldException("accessPolicyName"),
        cacheName = cacheName ?: throw PulumiNullFieldException("cacheName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
