@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.PersistenceArgs.builder
import com.pulumi.azurenative.cache.kotlin.enums.AofFrequency
import com.pulumi.azurenative.cache.kotlin.enums.RdbFrequency
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Persistence-related configuration for the RedisEnterprise database
 * @property aofEnabled Sets whether AOF is enabled.
 * @property aofFrequency Sets the frequency at which data is written to disk.
 * @property rdbEnabled Sets whether RDB is enabled.
 * @property rdbFrequency Sets the frequency at which a snapshot of the database is created.
 */
public data class PersistenceArgs(
    public val aofEnabled: Output<Boolean>? = null,
    public val aofFrequency: Output<Either<String, AofFrequency>>? = null,
    public val rdbEnabled: Output<Boolean>? = null,
    public val rdbFrequency: Output<Either<String, RdbFrequency>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.PersistenceArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.PersistenceArgs =
        com.pulumi.azurenative.cache.inputs.PersistenceArgs.builder()
            .aofEnabled(aofEnabled?.applyValue({ args0 -> args0 }))
            .aofFrequency(
                aofFrequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .rdbEnabled(rdbEnabled?.applyValue({ args0 -> args0 }))
            .rdbFrequency(
                rdbFrequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PersistenceArgs].
 */
@PulumiTagMarker
public class PersistenceArgsBuilder internal constructor() {
    private var aofEnabled: Output<Boolean>? = null

    private var aofFrequency: Output<Either<String, AofFrequency>>? = null

    private var rdbEnabled: Output<Boolean>? = null

    private var rdbFrequency: Output<Either<String, RdbFrequency>>? = null

    /**
     * @param value Sets whether AOF is enabled.
     */
    @JvmName("hrshqqwwnadsquqg")
    public suspend fun aofEnabled(`value`: Output<Boolean>) {
        this.aofEnabled = value
    }

    /**
     * @param value Sets the frequency at which data is written to disk.
     */
    @JvmName("vikarrfnyiwqavtf")
    public suspend fun aofFrequency(`value`: Output<Either<String, AofFrequency>>) {
        this.aofFrequency = value
    }

    /**
     * @param value Sets whether RDB is enabled.
     */
    @JvmName("sxrayuighwunosss")
    public suspend fun rdbEnabled(`value`: Output<Boolean>) {
        this.rdbEnabled = value
    }

    /**
     * @param value Sets the frequency at which a snapshot of the database is created.
     */
    @JvmName("oyapgbdrepjnxbhp")
    public suspend fun rdbFrequency(`value`: Output<Either<String, RdbFrequency>>) {
        this.rdbFrequency = value
    }

    /**
     * @param value Sets whether AOF is enabled.
     */
    @JvmName("gcfixnvlfdjlbhbs")
    public suspend fun aofEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aofEnabled = mapped
    }

    /**
     * @param value Sets the frequency at which data is written to disk.
     */
    @JvmName("txjtxthbgvaqgkwo")
    public suspend fun aofFrequency(`value`: Either<String, AofFrequency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aofFrequency = mapped
    }

    /**
     * @param value Sets the frequency at which data is written to disk.
     */
    @JvmName("pkxgtapbfnymqnhh")
    public fun aofFrequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AofFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aofFrequency = mapped
    }

    /**
     * @param value Sets the frequency at which data is written to disk.
     */
    @JvmName("nudureulsrawjiab")
    public fun aofFrequency(`value`: AofFrequency) {
        val toBeMapped = Either.ofRight<String, AofFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aofFrequency = mapped
    }

    /**
     * @param value Sets whether RDB is enabled.
     */
    @JvmName("gdiubisyeoluxcbe")
    public suspend fun rdbEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdbEnabled = mapped
    }

    /**
     * @param value Sets the frequency at which a snapshot of the database is created.
     */
    @JvmName("hujqtmaxbgqpokmg")
    public suspend fun rdbFrequency(`value`: Either<String, RdbFrequency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdbFrequency = mapped
    }

    /**
     * @param value Sets the frequency at which a snapshot of the database is created.
     */
    @JvmName("fkegsavxhmrkpaag")
    public fun rdbFrequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RdbFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rdbFrequency = mapped
    }

    /**
     * @param value Sets the frequency at which a snapshot of the database is created.
     */
    @JvmName("rnhylxjrtttmfjdv")
    public fun rdbFrequency(`value`: RdbFrequency) {
        val toBeMapped = Either.ofRight<String, RdbFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rdbFrequency = mapped
    }

    internal fun build(): PersistenceArgs = PersistenceArgs(
        aofEnabled = aofEnabled,
        aofFrequency = aofFrequency,
        rdbEnabled = rdbEnabled,
        rdbFrequency = rdbFrequency,
    )
}
