@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.ScheduleEntryArgs.builder
import com.pulumi.azurenative.cache.kotlin.enums.DayOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Patch schedule entry for a Premium Redis Cache.
 * @property dayOfWeek Day of the week when a cache can be patched.
 * @property maintenanceWindow ISO8601 timespan specifying how much time cache patching can take.
 * @property startHourUtc Start hour after which cache patching can start.
 */
public data class ScheduleEntryArgs(
    public val dayOfWeek: Output<DayOfWeek>,
    public val maintenanceWindow: Output<String>? = null,
    public val startHourUtc: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.ScheduleEntryArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.ScheduleEntryArgs =
        com.pulumi.azurenative.cache.inputs.ScheduleEntryArgs.builder()
            .dayOfWeek(dayOfWeek.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maintenanceWindow(maintenanceWindow?.applyValue({ args0 -> args0 }))
            .startHourUtc(startHourUtc.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleEntryArgs].
 */
@PulumiTagMarker
public class ScheduleEntryArgsBuilder internal constructor() {
    private var dayOfWeek: Output<DayOfWeek>? = null

    private var maintenanceWindow: Output<String>? = null

    private var startHourUtc: Output<Int>? = null

    /**
     * @param value Day of the week when a cache can be patched.
     */
    @JvmName("wudcqijebbkbbxps")
    public suspend fun dayOfWeek(`value`: Output<DayOfWeek>) {
        this.dayOfWeek = value
    }

    /**
     * @param value ISO8601 timespan specifying how much time cache patching can take.
     */
    @JvmName("raqpxucaboanuvop")
    public suspend fun maintenanceWindow(`value`: Output<String>) {
        this.maintenanceWindow = value
    }

    /**
     * @param value Start hour after which cache patching can start.
     */
    @JvmName("vlvbdaqlermhcheb")
    public suspend fun startHourUtc(`value`: Output<Int>) {
        this.startHourUtc = value
    }

    /**
     * @param value Day of the week when a cache can be patched.
     */
    @JvmName("noiopjvbqxwmrfjv")
    public suspend fun dayOfWeek(`value`: DayOfWeek) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    /**
     * @param value ISO8601 timespan specifying how much time cache patching can take.
     */
    @JvmName("aqgjnhqerfkrowiu")
    public suspend fun maintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindow = mapped
    }

    /**
     * @param value Start hour after which cache patching can start.
     */
    @JvmName("rhkpsmlntobvslkg")
    public suspend fun startHourUtc(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startHourUtc = mapped
    }

    internal fun build(): ScheduleEntryArgs = ScheduleEntryArgs(
        dayOfWeek = dayOfWeek ?: throw PulumiNullFieldException("dayOfWeek"),
        maintenanceWindow = maintenanceWindow,
        startHourUtc = startHourUtc ?: throw PulumiNullFieldException("startHourUtc"),
    )
}
