@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property identityType Only userAssignedIdentity is supported in this API version; other types may be supported in the future
 * @property userAssignedIdentityResourceId User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/<sub uuid>/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
 */
public data class ClusterPropertiesResponseKeyEncryptionKeyIdentity(
    public val identityType: String? = null,
    public val userAssignedIdentityResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.ClusterPropertiesResponseKeyEncryptionKeyIdentity): ClusterPropertiesResponseKeyEncryptionKeyIdentity =
            ClusterPropertiesResponseKeyEncryptionKeyIdentity(
                identityType = javaType.identityType().map({ args0 -> args0 }).orElse(null),
                userAssignedIdentityResourceId = javaType.userAssignedIdentityResourceId().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
