@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Response to put/get linked server (with properties) for Redis cache.
 * @property geoReplicatedPrimaryHostName The unchanging DNS name which will always point to current geo-primary cache among the linked redis caches for seamless Geo Failover experience.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property linkedRedisCacheId Fully qualified resourceId of the linked redis cache.
 * @property linkedRedisCacheLocation Location of the linked redis cache.
 * @property name The name of the resource
 * @property primaryHostName The changing DNS name that resolves to the current geo-primary cache among the linked redis caches before or after the Geo Failover.
 * @property provisioningState Terminal state of the link between primary and secondary redis cache.
 * @property serverRole Role of the linked server.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLinkedServerResult(
    public val geoReplicatedPrimaryHostName: String,
    public val id: String,
    public val linkedRedisCacheId: String,
    public val linkedRedisCacheLocation: String,
    public val name: String,
    public val primaryHostName: String,
    public val provisioningState: String,
    public val serverRole: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.GetLinkedServerResult): GetLinkedServerResult = GetLinkedServerResult(
            geoReplicatedPrimaryHostName = javaType.geoReplicatedPrimaryHostName(),
            id = javaType.id(),
            linkedRedisCacheId = javaType.linkedRedisCacheId(),
            linkedRedisCacheLocation = javaType.linkedRedisCacheLocation(),
            name = javaType.name(),
            primaryHostName = javaType.primaryHostName(),
            provisioningState = javaType.provisioningState(),
            serverRole = javaType.serverRole(),
            type = javaType.type(),
        )
    }
}
