@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response to put/get patch schedules for Redis cache.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property scheduleEntries List of patch schedules for a Redis cache.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPatchScheduleResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val scheduleEntries: List<ScheduleEntryResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.GetPatchScheduleResult): GetPatchScheduleResult = GetPatchScheduleResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            scheduleEntries = javaType.scheduleEntries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cache.kotlin.outputs.ScheduleEntryResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
