@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies details of a linked database resource.
 * @property id Resource ID of a database resource to link with this database.
 * @property state State of the link between the database resources.
 */
public data class LinkedDatabaseResponse(
    public val id: String? = null,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.LinkedDatabaseResponse): LinkedDatabaseResponse = LinkedDatabaseResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
        )
    }
}
