@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The secret access keys used for authenticating connections to redis
 * @property primaryKey The current primary key that clients can use to authenticate
 * @property secondaryKey The current secondary key that clients can use to authenticate
 */
public data class ListDatabaseKeysResult(
    public val primaryKey: String,
    public val secondaryKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.ListDatabaseKeysResult): ListDatabaseKeysResult = ListDatabaseKeysResult(
            primaryKey = javaType.primaryKey(),
            secondaryKey = javaType.secondaryKey(),
        )
    }
}
