@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Persistence-related configuration for the RedisEnterprise database
 * @property aofEnabled Sets whether AOF is enabled.
 * @property aofFrequency Sets the frequency at which data is written to disk.
 * @property rdbEnabled Sets whether RDB is enabled.
 * @property rdbFrequency Sets the frequency at which a snapshot of the database is created.
 */
public data class PersistenceResponse(
    public val aofEnabled: Boolean? = null,
    public val aofFrequency: String? = null,
    public val rdbEnabled: Boolean? = null,
    public val rdbFrequency: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.PersistenceResponse): PersistenceResponse = PersistenceResponse(
            aofEnabled = javaType.aofEnabled().map({ args0 -> args0 }).orElse(null),
            aofFrequency = javaType.aofFrequency().map({ args0 -> args0 }).orElse(null),
            rdbEnabled = javaType.rdbEnabled().map({ args0 -> args0 }).orElse(null),
            rdbFrequency = javaType.rdbFrequency().map({ args0 -> args0 }).orElse(null),
        )
    }
}
