@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Redis cache access keys.
 * @property primaryKey The current primary key that clients can use to authenticate with Redis cache.
 * @property secondaryKey The current secondary key that clients can use to authenticate with Redis cache.
 */
public data class RedisAccessKeysResponse(
    public val primaryKey: String,
    public val secondaryKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.RedisAccessKeysResponse): RedisAccessKeysResponse = RedisAccessKeysResponse(
            primaryKey = javaType.primaryKey(),
            secondaryKey = javaType.secondaryKey(),
        )
    }
}
