@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
 * @property aofBackupEnabled Specifies whether the aof backup is enabled
 * @property aofStorageConnectionString0 First storage account connection string
 * @property aofStorageConnectionString1 Second storage account connection string
 * @property authnotrequired Specifies whether the authentication is disabled. Setting this property is highly discouraged from security point of view.
 * @property maxclients The max clients config
 * @property maxfragmentationmemoryReserved Value in megabytes reserved for fragmentation per shard
 * @property maxmemoryDelta Value in megabytes reserved for non-cache usage per shard e.g. failover.
 * @property maxmemoryPolicy The eviction strategy used when your data won't fit within its memory limit.
 * @property maxmemoryReserved Value in megabytes reserved for non-cache usage per shard e.g. failover.
 * @property preferredDataArchiveAuthMethod Preferred auth method to communicate to storage account used for data archive, specify SAS or ManagedIdentity, default value is SAS
 * @property preferredDataPersistenceAuthMethod Preferred auth method to communicate to storage account used for data persistence, specify SAS or ManagedIdentity, default value is SAS
 * @property rdbBackupEnabled Specifies whether the rdb backup is enabled
 * @property rdbBackupFrequency Specifies the frequency for creating rdb backup in minutes. Valid values: (15, 30, 60, 360, 720, 1440)
 * @property rdbBackupMaxSnapshotCount Specifies the maximum number of snapshots for rdb backup
 * @property rdbStorageConnectionString The storage account connection string for storing rdb file
 * @property storageSubscriptionId SubscriptionId of the storage account for persistence (aof/rdb) using ManagedIdentity.
 * @property zonalConfiguration Zonal Configuration
 */
public data class RedisCommonPropertiesResponseRedisConfiguration(
    public val aofBackupEnabled: String? = null,
    public val aofStorageConnectionString0: String? = null,
    public val aofStorageConnectionString1: String? = null,
    public val authnotrequired: String? = null,
    public val maxclients: String,
    public val maxfragmentationmemoryReserved: String? = null,
    public val maxmemoryDelta: String? = null,
    public val maxmemoryPolicy: String? = null,
    public val maxmemoryReserved: String? = null,
    public val preferredDataArchiveAuthMethod: String,
    public val preferredDataPersistenceAuthMethod: String? = null,
    public val rdbBackupEnabled: String? = null,
    public val rdbBackupFrequency: String? = null,
    public val rdbBackupMaxSnapshotCount: String? = null,
    public val rdbStorageConnectionString: String? = null,
    public val storageSubscriptionId: String? = null,
    public val zonalConfiguration: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.RedisCommonPropertiesResponseRedisConfiguration): RedisCommonPropertiesResponseRedisConfiguration =
            RedisCommonPropertiesResponseRedisConfiguration(
                aofBackupEnabled = javaType.aofBackupEnabled().map({ args0 -> args0 }).orElse(null),
                aofStorageConnectionString0 = javaType.aofStorageConnectionString0().map({ args0 ->
                    args0
                }).orElse(null),
                aofStorageConnectionString1 = javaType.aofStorageConnectionString1().map({ args0 ->
                    args0
                }).orElse(null),
                authnotrequired = javaType.authnotrequired().map({ args0 -> args0 }).orElse(null),
                maxclients = javaType.maxclients(),
                maxfragmentationmemoryReserved = javaType.maxfragmentationmemoryReserved().map({ args0 ->
                    args0
                }).orElse(null),
                maxmemoryDelta = javaType.maxmemoryDelta().map({ args0 -> args0 }).orElse(null),
                maxmemoryPolicy = javaType.maxmemoryPolicy().map({ args0 -> args0 }).orElse(null),
                maxmemoryReserved = javaType.maxmemoryReserved().map({ args0 -> args0 }).orElse(null),
                preferredDataArchiveAuthMethod = javaType.preferredDataArchiveAuthMethod(),
                preferredDataPersistenceAuthMethod = javaType.preferredDataPersistenceAuthMethod().map({ args0 ->
                    args0
                }).orElse(null),
                rdbBackupEnabled = javaType.rdbBackupEnabled().map({ args0 -> args0 }).orElse(null),
                rdbBackupFrequency = javaType.rdbBackupFrequency().map({ args0 -> args0 }).orElse(null),
                rdbBackupMaxSnapshotCount = javaType.rdbBackupMaxSnapshotCount().map({ args0 ->
                    args0
                }).orElse(null),
                rdbStorageConnectionString = javaType.rdbStorageConnectionString().map({ args0 ->
                    args0
                }).orElse(null),
                storageSubscriptionId = javaType.storageSubscriptionId().map({ args0 -> args0 }).orElse(null),
                zonalConfiguration = javaType.zonalConfiguration(),
            )
    }
}
