@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Details of single instance of redis.
 * @property isMaster Specifies whether the instance is a primary node.
 * @property isPrimary Specifies whether the instance is a primary node.
 * @property nonSslPort If enableNonSslPort is true, provides Redis instance Non-SSL port.
 * @property shardId If clustering is enabled, the Shard ID of Redis Instance
 * @property sslPort Redis instance SSL port.
 * @property zone If the Cache uses availability zones, specifies availability zone where this instance is located.
 */
public data class RedisInstanceDetailsResponse(
    public val isMaster: Boolean,
    public val isPrimary: Boolean,
    public val nonSslPort: Int,
    public val shardId: Int,
    public val sslPort: Int,
    public val zone: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.RedisInstanceDetailsResponse): RedisInstanceDetailsResponse = RedisInstanceDetailsResponse(
            isMaster = javaType.isMaster(),
            isPrimary = javaType.isPrimary(),
            nonSslPort = javaType.nonSslPort(),
            shardId = javaType.shardId(),
            sslPort = javaType.sslPort(),
            zone = javaType.zone(),
        )
    }
}
