@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * SKU parameters supplied to the create Redis operation.
 * @property capacity The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
 * @property family The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
 * @property name The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium)
 */
public data class SkuResponse(
    public val capacity: Int,
    public val family: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                capacity = javaType.capacity(),
                family = javaType.family(),
                name = javaType.name(),
            )
    }
}
