@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AFDEndpoint].
 */
@PulumiTagMarker
public class AFDEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AFDEndpointArgs = AFDEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AFDEndpointArgsBuilder.() -> Unit) {
        val builder = AFDEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AFDEndpoint {
        val builtJavaResource = com.pulumi.azurenative.cdn.AFDEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AFDEndpoint(builtJavaResource)
    }
}

/**
 * Azure Front Door endpoint is the entity within a Azure Front Door profile containing configuration information such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format <endpointname>.azureedge.net.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2020-09-01, 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### AFDEndpoints_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var afdEndpoint = new AzureNative.Cdn.AFDEndpoint("afdEndpoint", new()
 *     {
 *         AutoGeneratedDomainNameLabelScope = AzureNative.Cdn.AutoGeneratedDomainNameLabelScope.TenantReuse,
 *         EnabledState = AzureNative.Cdn.EnabledState.Enabled,
 *         EndpointName = "endpoint1",
 *         Location = "global",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewAFDEndpoint(ctx, "afdEndpoint", &cdn.AFDEndpointArgs{
 * 			AutoGeneratedDomainNameLabelScope: pulumi.String(cdn.AutoGeneratedDomainNameLabelScopeTenantReuse),
 * 			EnabledState:                      pulumi.String(cdn.EnabledStateEnabled),
 * 			EndpointName:                      pulumi.String("endpoint1"),
 * 			Location:                          pulumi.String("global"),
 * 			ProfileName:                       pulumi.String("profile1"),
 * 			ResourceGroupName:                 pulumi.String("RG"),
 * 			Tags:                              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.AFDEndpoint;
 * import com.pulumi.azurenative.cdn.AFDEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var afdEndpoint = new AFDEndpoint("afdEndpoint", AFDEndpointArgs.builder()
 *             .autoGeneratedDomainNameLabelScope("TenantReuse")
 *             .enabledState("Enabled")
 *             .endpointName("endpoint1")
 *             .location("global")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:AFDEndpoint endpoint1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}
 * ```
 */
public class AFDEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.AFDEndpoint,
) : KotlinCustomResource(javaResource, AFDEndpointMapper) {
    /**
     * Indicates the endpoint name reuse scope. The default value is TenantReuse.
     */
    public val autoGeneratedDomainNameLabelScope: Output<String>?
        get() = javaResource.autoGeneratedDomainNameLabelScope().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    public val enabledState: Output<String>?
        get() = javaResource.enabledState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the profile which holds the endpoint.
     */
    public val profileName: Output<String>
        get() = javaResource.profileName().applyValue({ args0 -> args0 })

    /**
     * Provisioning status
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AFDEndpointMapper : ResourceMapper<AFDEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.AFDEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): AFDEndpoint = AFDEndpoint(
        javaResource as
            com.pulumi.azurenative.cdn.AFDEndpoint,
    )
}

/**
 * @see [AFDEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AFDEndpoint].
 */
public suspend fun afdEndpoint(name: String, block: suspend AFDEndpointResourceBuilder.() -> Unit): AFDEndpoint {
    val builder = AFDEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AFDEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun afdEndpoint(name: String): AFDEndpoint {
    val builder = AFDEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
