@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.CdnManagedHttpsParametersResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.UserManagedHttpsParametersResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CustomDomain].
 */
@PulumiTagMarker
public class CustomDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomDomainArgs = CustomDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomDomainArgsBuilder.() -> Unit) {
        val builder = CustomDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomDomain {
        val builtJavaResource = com.pulumi.azurenative.cdn.CustomDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomDomain(builtJavaResource)
    }
}

/**
 * Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-10-02, 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### CustomDomains_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customDomain = new AzureNative.Cdn.CustomDomain("customDomain", new()
 *     {
 *         CustomDomainName = "www-someDomain-net",
 *         EndpointName = "endpoint1",
 *         HostName = "www.someDomain.net",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewCustomDomain(ctx, "customDomain", &cdn.CustomDomainArgs{
 * 			CustomDomainName:  pulumi.String("www-someDomain-net"),
 * 			EndpointName:      pulumi.String("endpoint1"),
 * 			HostName:          pulumi.String("www.someDomain.net"),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.CustomDomain;
 * import com.pulumi.azurenative.cdn.CustomDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customDomain = new CustomDomain("customDomain", CustomDomainArgs.builder()
 *             .customDomainName("www-someDomain-net")
 *             .endpointName("endpoint1")
 *             .hostName("www.someDomain.net")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:CustomDomain www-someDomain-net /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}
 * ```
 */
public class CustomDomain internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.CustomDomain,
) : KotlinCustomResource(javaResource, CustomDomainMapper) {
    /**
     * Certificate parameters for securing custom HTTPS
     */
    public val customHttpsParameters:
        Output<Either<CdnManagedHttpsParametersResponse, UserManagedHttpsParametersResponse>>?
        get() = javaResource.customHttpsParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.cdn.kotlin.outputs.CdnManagedHttpsParametersResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.cdn.kotlin.outputs.UserManagedHttpsParametersResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null)
        })

    /**
     * Provisioning status of the custom domain.
     */
    public val customHttpsProvisioningState: Output<String>
        get() = javaResource.customHttpsProvisioningState().applyValue({ args0 -> args0 })

    /**
     * Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
     */
    public val customHttpsProvisioningSubstate: Output<String>
        get() = javaResource.customHttpsProvisioningSubstate().applyValue({ args0 -> args0 })

    /**
     * The host name of the custom domain. Must be a domain name.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning status of Custom Https of the custom domain.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource status of the custom domain.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China.
     */
    public val validationData: Output<String>?
        get() = javaResource.validationData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object CustomDomainMapper : ResourceMapper<CustomDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.CustomDomain::class == javaResource::class

    override fun map(javaResource: Resource): CustomDomain = CustomDomain(
        javaResource as
            com.pulumi.azurenative.cdn.CustomDomain,
    )
}

/**
 * @see [CustomDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomDomain].
 */
public suspend fun customDomain(
    name: String,
    block: suspend CustomDomainResourceBuilder.() -> Unit,
): CustomDomain {
    val builder = CustomDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customDomain(name: String): CustomDomain {
    val builder = CustomDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
