@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.CustomDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-10-02, 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### CustomDomains_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customDomain = new AzureNative.Cdn.CustomDomain("customDomain", new()
 *     {
 *         CustomDomainName = "www-someDomain-net",
 *         EndpointName = "endpoint1",
 *         HostName = "www.someDomain.net",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewCustomDomain(ctx, "customDomain", &cdn.CustomDomainArgs{
 * 			CustomDomainName:  pulumi.String("www-someDomain-net"),
 * 			EndpointName:      pulumi.String("endpoint1"),
 * 			HostName:          pulumi.String("www.someDomain.net"),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.CustomDomain;
 * import com.pulumi.azurenative.cdn.CustomDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customDomain = new CustomDomain("customDomain", CustomDomainArgs.builder()
 *             .customDomainName("www-someDomain-net")
 *             .endpointName("endpoint1")
 *             .hostName("www.someDomain.net")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:CustomDomain www-someDomain-net /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}
 * ```
 * @property customDomainName Name of the custom domain within an endpoint.
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property hostName The host name of the custom domain. Must be a domain name.
 * @property profileName Name of the CDN profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class CustomDomainArgs(
    public val customDomainName: Output<String>? = null,
    public val endpointName: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.CustomDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.CustomDomainArgs =
        com.pulumi.azurenative.cdn.CustomDomainArgs.builder()
            .customDomainName(customDomainName?.applyValue({ args0 -> args0 }))
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomDomainArgs].
 */
@PulumiTagMarker
public class CustomDomainArgsBuilder internal constructor() {
    private var customDomainName: Output<String>? = null

    private var endpointName: Output<String>? = null

    private var hostName: Output<String>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the custom domain within an endpoint.
     */
    @JvmName("dwsctarshjajmshl")
    public suspend fun customDomainName(`value`: Output<String>) {
        this.customDomainName = value
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("nvcrpvtehxoxylsq")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value The host name of the custom domain. Must be a domain name.
     */
    @JvmName("efxfbhutkmxikhbv")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("qgcvibiuyulcgyik")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("bjivcsxnmhlcequp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the custom domain within an endpoint.
     */
    @JvmName("lobjlfiyhohkgsnv")
    public suspend fun customDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomainName = mapped
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("cdqwantxdipvthoa")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value The host name of the custom domain. Must be a domain name.
     */
    @JvmName("kbhtvdwmiyimkfqg")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("nxfmmjgvlnxjarhn")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("hixptnnuuimeklus")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CustomDomainArgs = CustomDomainArgs(
        customDomainName = customDomainName,
        endpointName = endpointName,
        hostName = hostName,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
    )
}
