@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.DeepCreatedCustomDomainResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.DeepCreatedOriginGroupResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.DeepCreatedOriginResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.EndpointPropertiesUpdateParametersResponseDeliveryPolicy
import com.pulumi.azurenative.cdn.kotlin.outputs.EndpointPropertiesUpdateParametersResponseWebApplicationFirewallPolicyLink
import com.pulumi.azurenative.cdn.kotlin.outputs.GeoFilterResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.UrlSigningKeyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.cdn.kotlin.outputs.DeepCreatedCustomDomainResponse.Companion.toKotlin as deepCreatedCustomDomainResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.DeepCreatedOriginGroupResponse.Companion.toKotlin as deepCreatedOriginGroupResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.DeepCreatedOriginResponse.Companion.toKotlin as deepCreatedOriginResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.EndpointPropertiesUpdateParametersResponseDeliveryPolicy.Companion.toKotlin as endpointPropertiesUpdateParametersResponseDeliveryPolicyToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.EndpointPropertiesUpdateParametersResponseWebApplicationFirewallPolicyLink.Companion.toKotlin as endpointPropertiesUpdateParametersResponseWebApplicationFirewallPolicyLinkToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.GeoFilterResponse.Companion.toKotlin as geoFilterResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.UrlSigningKeyResponse.Companion.toKotlin as urlSigningKeyResponseToKotlin

/**
 * Builder for [Endpoint].
 */
@PulumiTagMarker
public class EndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointArgs = EndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointArgsBuilder.() -> Unit) {
        val builder = EndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Endpoint {
        val builtJavaResource = com.pulumi.azurenative.cdn.Endpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Endpoint(builtJavaResource)
    }
}

/**
 * CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format <endpointname>.azureedge.net.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-04-02, 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Endpoints_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Cdn.Endpoint("endpoint", new()
 *     {
 *         ContentTypesToCompress = new[]
 *         {
 *             "text/html",
 *             "application/octet-stream",
 *         },
 *         DefaultOriginGroup = new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1",
 *         },
 *         DeliveryPolicy = new AzureNative.Cdn.Inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgs
 *         {
 *             Description = "Test description for a policy.",
 *             Rules = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.DeliveryRuleArgs
 *                 {
 *                     Actions =
 *                     {
 *                         new AzureNative.Cdn.Inputs.DeliveryRuleCacheExpirationActionArgs
 *                         {
 *                             Name = "CacheExpiration",
 *                             Parameters = new AzureNative.Cdn.Inputs.CacheExpirationActionParametersArgs
 *                             {
 *                                 CacheBehavior = AzureNative.Cdn.CacheBehavior.Override,
 *                                 CacheDuration = "10:10:09",
 *                                 CacheType = AzureNative.Cdn.CacheType.All,
 *                                 TypeName = "DeliveryRuleCacheExpirationActionParameters",
 *                             },
 *                         },
 *                         new AzureNative.Cdn.Inputs.DeliveryRuleResponseHeaderActionArgs
 *                         {
 *                             Name = "ModifyResponseHeader",
 *                             Parameters = new AzureNative.Cdn.Inputs.HeaderActionParametersArgs
 *                             {
 *                                 HeaderAction = AzureNative.Cdn.HeaderAction.Overwrite,
 *                                 HeaderName = "Access-Control-Allow-Origin",
 *                                 TypeName = "DeliveryRuleHeaderActionParameters",
 *                                 Value = "*",
 *                             },
 *                         },
 *                         new AzureNative.Cdn.Inputs.DeliveryRuleRequestHeaderActionArgs
 *                         {
 *                             Name = "ModifyRequestHeader",
 *                             Parameters = new AzureNative.Cdn.Inputs.HeaderActionParametersArgs
 *                             {
 *                                 HeaderAction = AzureNative.Cdn.HeaderAction.Overwrite,
 *                                 HeaderName = "Accept-Encoding",
 *                                 TypeName = "DeliveryRuleHeaderActionParameters",
 *                                 Value = "gzip",
 *                             },
 *                         },
 *                     },
 *                     Conditions = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.DeliveryRuleRemoteAddressConditionArgs
 *                         {
 *                             Name = "RemoteAddress",
 *                             Parameters = new AzureNative.Cdn.Inputs.RemoteAddressMatchConditionParametersArgs
 *                             {
 *                                 MatchValues = new[]
 *                                 {
 *                                     "192.168.1.0/24",
 *                                     "10.0.0.0/24",
 *                                 },
 *                                 NegateCondition = true,
 *                                 Operator = AzureNative.Cdn.RemoteAddressOperator.IPMatch,
 *                                 TypeName = "DeliveryRuleRemoteAddressConditionParameters",
 *                             },
 *                         },
 *                     },
 *                     Name = "rule1",
 *                     Order = 1,
 *                 },
 *             },
 *         },
 *         EndpointName = "endpoint1",
 *         IsCompressionEnabled = true,
 *         IsHttpAllowed = true,
 *         IsHttpsAllowed = true,
 *         Location = "WestUs",
 *         OriginGroups = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.DeepCreatedOriginGroupArgs
 *             {
 *                 HealthProbeSettings = new AzureNative.Cdn.Inputs.HealthProbeParametersArgs
 *                 {
 *                     ProbeIntervalInSeconds = 120,
 *                     ProbePath = "/health.aspx",
 *                     ProbeProtocol = AzureNative.Cdn.ProbeProtocol.Http,
 *                     ProbeRequestType = AzureNative.Cdn.HealthProbeRequestType.GET,
 *                 },
 *                 Name = "originGroup1",
 *                 Origins = new[]
 *                 {
 *                     new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1",
 *                     },
 *                     new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin2",
 *                     },
 *                 },
 *                 ResponseBasedOriginErrorDetectionSettings = new AzureNative.Cdn.Inputs.ResponseBasedOriginErrorDetectionParametersArgs
 *                 {
 *                     ResponseBasedDetectedErrorTypes = AzureNative.Cdn.ResponseBasedDetectedErrorTypes.TcpErrorsOnly,
 *                     ResponseBasedFailoverThresholdPercentage = 10,
 *                 },
 *             },
 *         },
 *         OriginHostHeader = "www.bing.com",
 *         OriginPath = "/photos",
 *         Origins = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.DeepCreatedOriginArgs
 *             {
 *                 Enabled = true,
 *                 HostName = "www.someDomain1.net",
 *                 HttpPort = 80,
 *                 HttpsPort = 443,
 *                 Name = "origin1",
 *                 OriginHostHeader = "www.someDomain1.net",
 *                 Priority = 1,
 *                 Weight = 50,
 *             },
 *             new AzureNative.Cdn.Inputs.DeepCreatedOriginArgs
 *             {
 *                 Enabled = true,
 *                 HostName = "www.someDomain2.net",
 *                 HttpPort = 80,
 *                 HttpsPort = 443,
 *                 Name = "origin2",
 *                 OriginHostHeader = "www.someDomain2.net",
 *                 Priority = 2,
 *                 Weight = 50,
 *             },
 *         },
 *         ProfileName = "profile1",
 *         QueryStringCachingBehavior = AzureNative.Cdn.QueryStringCachingBehavior.BypassCaching,
 *         ResourceGroupName = "RG",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewEndpoint(ctx, "endpoint", &cdn.EndpointArgs{
 * 			ContentTypesToCompress: pulumi.StringArray{
 * 				pulumi.String("text/html"),
 * 				pulumi.String("application/octet-stream"),
 * 			},
 * 			DefaultOriginGroup: &cdn.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1"),
 * 			},
 * 			DeliveryPolicy: &cdn.EndpointPropertiesUpdateParametersDeliveryPolicyArgs{
 * 				Description: pulumi.String("Test description for a policy."),
 * 				Rules: []cdn.DeliveryRuleArgs{
 * 					{
 * 						Actions: pulumi.Array{
 * 							{
 * 								Name: "CacheExpiration",
 * 								Parameters: {
 * 									CacheBehavior: cdn.CacheBehaviorOverride,
 * 									CacheDuration: "10:10:09",
 * 									CacheType:     cdn.CacheTypeAll,
 * 									TypeName:      "DeliveryRuleCacheExpirationActionParameters",
 * 								},
 * 							},
 * 							{
 * 								Name: "ModifyResponseHeader",
 * 								Parameters: {
 * 									HeaderAction: cdn.HeaderActionOverwrite,
 * 									HeaderName:   "Access-Control-Allow-Origin",
 * 									TypeName:     "DeliveryRuleHeaderActionParameters",
 * 									Value:        "*",
 * 								},
 * 							},
 * 							{
 * 								Name: "ModifyRequestHeader",
 * 								Parameters: {
 * 									HeaderAction: cdn.HeaderActionOverwrite,
 * 									HeaderName:   "Accept-Encoding",
 * 									TypeName:     "DeliveryRuleHeaderActionParameters",
 * 									Value:        "gzip",
 * 								},
 * 							},
 * 						},
 * 						Conditions: pulumi.Array{
 * 							{
 * 								Name: "RemoteAddress",
 * 								Parameters: {
 * 									MatchValues: []string{
 * 										"192.168.1.0/24",
 * 										"10.0.0.0/24",
 * 									},
 * 									NegateCondition: true,
 * 									Operator:        cdn.RemoteAddressOperatorIPMatch,
 * 									TypeName:        "DeliveryRuleRemoteAddressConditionParameters",
 * 								},
 * 							},
 * 						},
 * 						Name:  pulumi.String("rule1"),
 * 						Order: pulumi.Int(1),
 * 					},
 * 				},
 * 			},
 * 			EndpointName:         pulumi.String("endpoint1"),
 * 			IsCompressionEnabled: pulumi.Bool(true),
 * 			IsHttpAllowed:        pulumi.Bool(true),
 * 			IsHttpsAllowed:       pulumi.Bool(true),
 * 			Location:             pulumi.String("WestUs"),
 * 			OriginGroups: cdn.DeepCreatedOriginGroupArray{
 * 				&cdn.DeepCreatedOriginGroupArgs{
 * 					HealthProbeSettings: &cdn.HealthProbeParametersArgs{
 * 						ProbeIntervalInSeconds: pulumi.Int(120),
 * 						ProbePath:              pulumi.String("/health.aspx"),
 * 						ProbeProtocol:          cdn.ProbeProtocolHttp,
 * 						ProbeRequestType:       cdn.HealthProbeRequestTypeGET,
 * 					},
 * 					Name: pulumi.String("originGroup1"),
 * 					Origins: cdn.ResourceReferenceArray{
 * 						&cdn.ResourceReferenceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1"),
 * 						},
 * 						&cdn.ResourceReferenceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin2"),
 * 						},
 * 					},
 * 					ResponseBasedOriginErrorDetectionSettings: &cdn.ResponseBasedOriginErrorDetectionParametersArgs{
 * 						ResponseBasedDetectedErrorTypes:          cdn.ResponseBasedDetectedErrorTypesTcpErrorsOnly,
 * 						ResponseBasedFailoverThresholdPercentage: pulumi.Int(10),
 * 					},
 * 				},
 * 			},
 * 			OriginHostHeader: pulumi.String("www.bing.com"),
 * 			OriginPath:       pulumi.String("/photos"),
 * 			Origins: cdn.DeepCreatedOriginArray{
 * 				&cdn.DeepCreatedOriginArgs{
 * 					Enabled:          pulumi.Bool(true),
 * 					HostName:         pulumi.String("www.someDomain1.net"),
 * 					HttpPort:         pulumi.Int(80),
 * 					HttpsPort:        pulumi.Int(443),
 * 					Name:             pulumi.String("origin1"),
 * 					OriginHostHeader: pulumi.String("www.someDomain1.net"),
 * 					Priority:         pulumi.Int(1),
 * 					Weight:           pulumi.Int(50),
 * 				},
 * 				&cdn.DeepCreatedOriginArgs{
 * 					Enabled:          pulumi.Bool(true),
 * 					HostName:         pulumi.String("www.someDomain2.net"),
 * 					HttpPort:         pulumi.Int(80),
 * 					HttpsPort:        pulumi.Int(443),
 * 					Name:             pulumi.String("origin2"),
 * 					OriginHostHeader: pulumi.String("www.someDomain2.net"),
 * 					Priority:         pulumi.Int(2),
 * 					Weight:           pulumi.Int(50),
 * 				},
 * 			},
 * 			ProfileName:                pulumi.String("profile1"),
 * 			QueryStringCachingBehavior: cdn.QueryStringCachingBehaviorBypassCaching,
 * 			ResourceGroupName:          pulumi.String("RG"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Endpoint;
 * import com.pulumi.azurenative.cdn.EndpointArgs;
 * import com.pulumi.azurenative.cdn.inputs.ResourceReferenceArgs;
 * import com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgs;
 * import com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginGroupArgs;
 * import com.pulumi.azurenative.cdn.inputs.HealthProbeParametersArgs;
 * import com.pulumi.azurenative.cdn.inputs.ResponseBasedOriginErrorDetectionParametersArgs;
 * import com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .contentTypesToCompress(
 *                 "text/html",
 *                 "application/octet-stream")
 *             .defaultOriginGroup(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1")
 *                 .build())
 *             .deliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicyArgs.builder()
 *                 .description("Test description for a policy.")
 *                 .rules(DeliveryRuleArgs.builder()
 *                     .actions(
 *                         DeliveryRuleCacheExpirationActionArgs.builder()
 *                             .name("CacheExpiration")
 *                             .parameters(CacheExpirationActionParametersArgs.builder()
 *                                 .cacheBehavior("Override")
 *                                 .cacheDuration("10:10:09")
 *                                 .cacheType("All")
 *                                 .typeName("DeliveryRuleCacheExpirationActionParameters")
 *                                 .build())
 *                             .build(),
 *                         DeliveryRuleCacheExpirationActionArgs.builder()
 *                             .name("ModifyResponseHeader")
 *                             .parameters(CacheExpirationActionParametersArgs.builder()
 *                                 .headerAction("Overwrite")
 *                                 .headerName("Access-Control-Allow-Origin")
 *                                 .typeName("DeliveryRuleHeaderActionParameters")
 *                                 .value("*")
 *                                 .build())
 *                             .build(),
 *                         DeliveryRuleCacheExpirationActionArgs.builder()
 *                             .name("ModifyRequestHeader")
 *                             .parameters(CacheExpirationActionParametersArgs.builder()
 *                                 .headerAction("Overwrite")
 *                                 .headerName("Accept-Encoding")
 *                                 .typeName("DeliveryRuleHeaderActionParameters")
 *                                 .value("gzip")
 *                                 .build())
 *                             .build())
 *                     .conditions(DeliveryRuleRemoteAddressConditionArgs.builder()
 *                         .name("RemoteAddress")
 *                         .parameters(RemoteAddressMatchConditionParametersArgs.builder()
 *                             .matchValues(
 *                                 "192.168.1.0/24",
 *                                 "10.0.0.0/24")
 *                             .negateCondition(true)
 *                             .operator("IPMatch")
 *                             .typeName("DeliveryRuleRemoteAddressConditionParameters")
 *                             .build())
 *                         .build())
 *                     .name("rule1")
 *                     .order(1)
 *                     .build())
 *                 .build())
 *             .endpointName("endpoint1")
 *             .isCompressionEnabled(true)
 *             .isHttpAllowed(true)
 *             .isHttpsAllowed(true)
 *             .location("WestUs")
 *             .originGroups(DeepCreatedOriginGroupArgs.builder()
 *                 .healthProbeSettings(HealthProbeParametersArgs.builder()
 *                     .probeIntervalInSeconds(120)
 *                     .probePath("/health.aspx")
 *                     .probeProtocol("Http")
 *                     .probeRequestType("GET")
 *                     .build())
 *                 .name("originGroup1")
 *                 .origins(
 *                     ResourceReferenceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1")
 *                         .build(),
 *                     ResourceReferenceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin2")
 *                         .build())
 *                 .responseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParametersArgs.builder()
 *                     .responseBasedDetectedErrorTypes("TcpErrorsOnly")
 *                     .responseBasedFailoverThresholdPercentage(10)
 *                     .build())
 *                 .build())
 *             .originHostHeader("www.bing.com")
 *             .originPath("/photos")
 *             .origins(
 *                 DeepCreatedOriginArgs.builder()
 *                     .enabled(true)
 *                     .hostName("www.someDomain1.net")
 *                     .httpPort(80)
 *                     .httpsPort(443)
 *                     .name("origin1")
 *                     .originHostHeader("www.someDomain1.net")
 *                     .priority(1)
 *                     .weight(50)
 *                     .build(),
 *                 DeepCreatedOriginArgs.builder()
 *                     .enabled(true)
 *                     .hostName("www.someDomain2.net")
 *                     .httpPort(80)
 *                     .httpsPort(443)
 *                     .name("origin2")
 *                     .originHostHeader("www.someDomain2.net")
 *                     .priority(2)
 *                     .weight(50)
 *                     .build())
 *             .profileName("profile1")
 *             .queryStringCachingBehavior("BypassCaching")
 *             .resourceGroupName("RG")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Endpoint endpoint4899 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}
 * ```
 */
public class Endpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.Endpoint,
) : KotlinCustomResource(javaResource, EndpointMapper) {
    /**
     * List of content types on which compression applies. The value should be a valid MIME type.
     */
    public val contentTypesToCompress: Output<List<String>>?
        get() = javaResource.contentTypesToCompress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The custom domains under the endpoint.
     */
    public val customDomains: Output<List<DeepCreatedCustomDomainResponse>>
        get() = javaResource.customDomains().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deepCreatedCustomDomainResponseToKotlin(args0) })
            })
        })

    /**
     * A reference to the origin group.
     */
    public val defaultOriginGroup: Output<ResourceReferenceResponse>?
        get() = javaResource.defaultOriginGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A policy that specifies the delivery rules to be used for an endpoint.
     */
    public val deliveryPolicy: Output<EndpointPropertiesUpdateParametersResponseDeliveryPolicy>?
        get() = javaResource.deliveryPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    endpointPropertiesUpdateParametersResponseDeliveryPolicyToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
     */
    public val geoFilters: Output<List<GeoFilterResponse>>?
        get() = javaResource.geoFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> geoFilterResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
     */
    public val isCompressionEnabled: Output<Boolean>?
        get() = javaResource.isCompressionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    public val isHttpAllowed: Output<Boolean>?
        get() = javaResource.isHttpAllowed().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    public val isHttpsAllowed: Output<Boolean>?
        get() = javaResource.isHttpsAllowed().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
     */
    public val optimizationType: Output<String>?
        get() = javaResource.optimizationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The origin groups comprising of origins that are used for load balancing the traffic based on availability.
     */
    public val originGroups: Output<List<DeepCreatedOriginGroupResponse>>?
        get() = javaResource.originGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> deepCreatedOriginGroupResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
     */
    public val originHostHeader: Output<String>?
        get() = javaResource.originHostHeader().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
     */
    public val originPath: Output<String>?
        get() = javaResource.originPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The source of the content being delivered via CDN.
     */
    public val origins: Output<List<DeepCreatedOriginResponse>>
        get() = javaResource.origins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    deepCreatedOriginResponseToKotlin(args0)
                })
            })
        })

    /**
     * Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is only relevant when using a single origin.
     */
    public val probePath: Output<String>?
        get() = javaResource.probePath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Provisioning status of the endpoint.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL.
     */
    public val queryStringCachingBehavior: Output<String>?
        get() = javaResource.queryStringCachingBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource status of the endpoint.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of keys used to validate the signed URL hashes.
     */
    public val urlSigningKeys: Output<List<UrlSigningKeyResponse>>?
        get() = javaResource.urlSigningKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        urlSigningKeyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Defines the Web Application Firewall policy for the endpoint (if applicable)
     */
    public val webApplicationFirewallPolicyLink:
        Output<EndpointPropertiesUpdateParametersResponseWebApplicationFirewallPolicyLink>?
        get() = javaResource.webApplicationFirewallPolicyLink().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    endpointPropertiesUpdateParametersResponseWebApplicationFirewallPolicyLinkToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object EndpointMapper : ResourceMapper<Endpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.Endpoint::class == javaResource::class

    override fun map(javaResource: Resource): Endpoint = Endpoint(
        javaResource as
            com.pulumi.azurenative.cdn.Endpoint,
    )
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Endpoint].
 */
public suspend fun endpoint(name: String, block: suspend EndpointResourceBuilder.() -> Unit): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpoint(name: String): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
