@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.EndpointArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.OptimizationType
import com.pulumi.azurenative.cdn.kotlin.enums.QueryStringCachingBehavior
import com.pulumi.azurenative.cdn.kotlin.inputs.DeepCreatedOriginArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.DeepCreatedOriginArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.DeepCreatedOriginGroupArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.DeepCreatedOriginGroupArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.GeoFilterArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.GeoFilterArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.UrlSigningKeyArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.UrlSigningKeyArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format <endpointname>.azureedge.net.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-04-02, 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Endpoints_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Cdn.Endpoint("endpoint", new()
 *     {
 *         ContentTypesToCompress = new[]
 *         {
 *             "text/html",
 *             "application/octet-stream",
 *         },
 *         DefaultOriginGroup = new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1",
 *         },
 *         DeliveryPolicy = new AzureNative.Cdn.Inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgs
 *         {
 *             Description = "Test description for a policy.",
 *             Rules = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.DeliveryRuleArgs
 *                 {
 *                     Actions =
 *                     {
 *                         new AzureNative.Cdn.Inputs.DeliveryRuleCacheExpirationActionArgs
 *                         {
 *                             Name = "CacheExpiration",
 *                             Parameters = new AzureNative.Cdn.Inputs.CacheExpirationActionParametersArgs
 *                             {
 *                                 CacheBehavior = AzureNative.Cdn.CacheBehavior.Override,
 *                                 CacheDuration = "10:10:09",
 *                                 CacheType = AzureNative.Cdn.CacheType.All,
 *                                 TypeName = "DeliveryRuleCacheExpirationActionParameters",
 *                             },
 *                         },
 *                         new AzureNative.Cdn.Inputs.DeliveryRuleResponseHeaderActionArgs
 *                         {
 *                             Name = "ModifyResponseHeader",
 *                             Parameters = new AzureNative.Cdn.Inputs.HeaderActionParametersArgs
 *                             {
 *                                 HeaderAction = AzureNative.Cdn.HeaderAction.Overwrite,
 *                                 HeaderName = "Access-Control-Allow-Origin",
 *                                 TypeName = "DeliveryRuleHeaderActionParameters",
 *                                 Value = "*",
 *                             },
 *                         },
 *                         new AzureNative.Cdn.Inputs.DeliveryRuleRequestHeaderActionArgs
 *                         {
 *                             Name = "ModifyRequestHeader",
 *                             Parameters = new AzureNative.Cdn.Inputs.HeaderActionParametersArgs
 *                             {
 *                                 HeaderAction = AzureNative.Cdn.HeaderAction.Overwrite,
 *                                 HeaderName = "Accept-Encoding",
 *                                 TypeName = "DeliveryRuleHeaderActionParameters",
 *                                 Value = "gzip",
 *                             },
 *                         },
 *                     },
 *                     Conditions = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.DeliveryRuleRemoteAddressConditionArgs
 *                         {
 *                             Name = "RemoteAddress",
 *                             Parameters = new AzureNative.Cdn.Inputs.RemoteAddressMatchConditionParametersArgs
 *                             {
 *                                 MatchValues = new[]
 *                                 {
 *                                     "192.168.1.0/24",
 *                                     "10.0.0.0/24",
 *                                 },
 *                                 NegateCondition = true,
 *                                 Operator = AzureNative.Cdn.RemoteAddressOperator.IPMatch,
 *                                 TypeName = "DeliveryRuleRemoteAddressConditionParameters",
 *                             },
 *                         },
 *                     },
 *                     Name = "rule1",
 *                     Order = 1,
 *                 },
 *             },
 *         },
 *         EndpointName = "endpoint1",
 *         IsCompressionEnabled = true,
 *         IsHttpAllowed = true,
 *         IsHttpsAllowed = true,
 *         Location = "WestUs",
 *         OriginGroups = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.DeepCreatedOriginGroupArgs
 *             {
 *                 HealthProbeSettings = new AzureNative.Cdn.Inputs.HealthProbeParametersArgs
 *                 {
 *                     ProbeIntervalInSeconds = 120,
 *                     ProbePath = "/health.aspx",
 *                     ProbeProtocol = AzureNative.Cdn.ProbeProtocol.Http,
 *                     ProbeRequestType = AzureNative.Cdn.HealthProbeRequestType.GET,
 *                 },
 *                 Name = "originGroup1",
 *                 Origins = new[]
 *                 {
 *                     new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1",
 *                     },
 *                     new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin2",
 *                     },
 *                 },
 *                 ResponseBasedOriginErrorDetectionSettings = new AzureNative.Cdn.Inputs.ResponseBasedOriginErrorDetectionParametersArgs
 *                 {
 *                     ResponseBasedDetectedErrorTypes = AzureNative.Cdn.ResponseBasedDetectedErrorTypes.TcpErrorsOnly,
 *                     ResponseBasedFailoverThresholdPercentage = 10,
 *                 },
 *             },
 *         },
 *         OriginHostHeader = "www.bing.com",
 *         OriginPath = "/photos",
 *         Origins = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.DeepCreatedOriginArgs
 *             {
 *                 Enabled = true,
 *                 HostName = "www.someDomain1.net",
 *                 HttpPort = 80,
 *                 HttpsPort = 443,
 *                 Name = "origin1",
 *                 OriginHostHeader = "www.someDomain1.net",
 *                 Priority = 1,
 *                 Weight = 50,
 *             },
 *             new AzureNative.Cdn.Inputs.DeepCreatedOriginArgs
 *             {
 *                 Enabled = true,
 *                 HostName = "www.someDomain2.net",
 *                 HttpPort = 80,
 *                 HttpsPort = 443,
 *                 Name = "origin2",
 *                 OriginHostHeader = "www.someDomain2.net",
 *                 Priority = 2,
 *                 Weight = 50,
 *             },
 *         },
 *         ProfileName = "profile1",
 *         QueryStringCachingBehavior = AzureNative.Cdn.QueryStringCachingBehavior.BypassCaching,
 *         ResourceGroupName = "RG",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewEndpoint(ctx, "endpoint", &cdn.EndpointArgs{
 * 			ContentTypesToCompress: pulumi.StringArray{
 * 				pulumi.String("text/html"),
 * 				pulumi.String("application/octet-stream"),
 * 			},
 * 			DefaultOriginGroup: &cdn.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1"),
 * 			},
 * 			DeliveryPolicy: &cdn.EndpointPropertiesUpdateParametersDeliveryPolicyArgs{
 * 				Description: pulumi.String("Test description for a policy."),
 * 				Rules: []cdn.DeliveryRuleArgs{
 * 					{
 * 						Actions: pulumi.Array{
 * 							{
 * 								Name: "CacheExpiration",
 * 								Parameters: {
 * 									CacheBehavior: cdn.CacheBehaviorOverride,
 * 									CacheDuration: "10:10:09",
 * 									CacheType:     cdn.CacheTypeAll,
 * 									TypeName:      "DeliveryRuleCacheExpirationActionParameters",
 * 								},
 * 							},
 * 							{
 * 								Name: "ModifyResponseHeader",
 * 								Parameters: {
 * 									HeaderAction: cdn.HeaderActionOverwrite,
 * 									HeaderName:   "Access-Control-Allow-Origin",
 * 									TypeName:     "DeliveryRuleHeaderActionParameters",
 * 									Value:        "*",
 * 								},
 * 							},
 * 							{
 * 								Name: "ModifyRequestHeader",
 * 								Parameters: {
 * 									HeaderAction: cdn.HeaderActionOverwrite,
 * 									HeaderName:   "Accept-Encoding",
 * 									TypeName:     "DeliveryRuleHeaderActionParameters",
 * 									Value:        "gzip",
 * 								},
 * 							},
 * 						},
 * 						Conditions: pulumi.Array{
 * 							{
 * 								Name: "RemoteAddress",
 * 								Parameters: {
 * 									MatchValues: []string{
 * 										"192.168.1.0/24",
 * 										"10.0.0.0/24",
 * 									},
 * 									NegateCondition: true,
 * 									Operator:        cdn.RemoteAddressOperatorIPMatch,
 * 									TypeName:        "DeliveryRuleRemoteAddressConditionParameters",
 * 								},
 * 							},
 * 						},
 * 						Name:  pulumi.String("rule1"),
 * 						Order: pulumi.Int(1),
 * 					},
 * 				},
 * 			},
 * 			EndpointName:         pulumi.String("endpoint1"),
 * 			IsCompressionEnabled: pulumi.Bool(true),
 * 			IsHttpAllowed:        pulumi.Bool(true),
 * 			IsHttpsAllowed:       pulumi.Bool(true),
 * 			Location:             pulumi.String("WestUs"),
 * 			OriginGroups: cdn.DeepCreatedOriginGroupArray{
 * 				&cdn.DeepCreatedOriginGroupArgs{
 * 					HealthProbeSettings: &cdn.HealthProbeParametersArgs{
 * 						ProbeIntervalInSeconds: pulumi.Int(120),
 * 						ProbePath:              pulumi.String("/health.aspx"),
 * 						ProbeProtocol:          cdn.ProbeProtocolHttp,
 * 						ProbeRequestType:       cdn.HealthProbeRequestTypeGET,
 * 					},
 * 					Name: pulumi.String("originGroup1"),
 * 					Origins: cdn.ResourceReferenceArray{
 * 						&cdn.ResourceReferenceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1"),
 * 						},
 * 						&cdn.ResourceReferenceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin2"),
 * 						},
 * 					},
 * 					ResponseBasedOriginErrorDetectionSettings: &cdn.ResponseBasedOriginErrorDetectionParametersArgs{
 * 						ResponseBasedDetectedErrorTypes:          cdn.ResponseBasedDetectedErrorTypesTcpErrorsOnly,
 * 						ResponseBasedFailoverThresholdPercentage: pulumi.Int(10),
 * 					},
 * 				},
 * 			},
 * 			OriginHostHeader: pulumi.String("www.bing.com"),
 * 			OriginPath:       pulumi.String("/photos"),
 * 			Origins: cdn.DeepCreatedOriginArray{
 * 				&cdn.DeepCreatedOriginArgs{
 * 					Enabled:          pulumi.Bool(true),
 * 					HostName:         pulumi.String("www.someDomain1.net"),
 * 					HttpPort:         pulumi.Int(80),
 * 					HttpsPort:        pulumi.Int(443),
 * 					Name:             pulumi.String("origin1"),
 * 					OriginHostHeader: pulumi.String("www.someDomain1.net"),
 * 					Priority:         pulumi.Int(1),
 * 					Weight:           pulumi.Int(50),
 * 				},
 * 				&cdn.DeepCreatedOriginArgs{
 * 					Enabled:          pulumi.Bool(true),
 * 					HostName:         pulumi.String("www.someDomain2.net"),
 * 					HttpPort:         pulumi.Int(80),
 * 					HttpsPort:        pulumi.Int(443),
 * 					Name:             pulumi.String("origin2"),
 * 					OriginHostHeader: pulumi.String("www.someDomain2.net"),
 * 					Priority:         pulumi.Int(2),
 * 					Weight:           pulumi.Int(50),
 * 				},
 * 			},
 * 			ProfileName:                pulumi.String("profile1"),
 * 			QueryStringCachingBehavior: cdn.QueryStringCachingBehaviorBypassCaching,
 * 			ResourceGroupName:          pulumi.String("RG"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Endpoint;
 * import com.pulumi.azurenative.cdn.EndpointArgs;
 * import com.pulumi.azurenative.cdn.inputs.ResourceReferenceArgs;
 * import com.pulumi.azurenative.cdn.inputs.EndpointPropertiesUpdateParametersDeliveryPolicyArgs;
 * import com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginGroupArgs;
 * import com.pulumi.azurenative.cdn.inputs.HealthProbeParametersArgs;
 * import com.pulumi.azurenative.cdn.inputs.ResponseBasedOriginErrorDetectionParametersArgs;
 * import com.pulumi.azurenative.cdn.inputs.DeepCreatedOriginArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .contentTypesToCompress(
 *                 "text/html",
 *                 "application/octet-stream")
 *             .defaultOriginGroup(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1")
 *                 .build())
 *             .deliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicyArgs.builder()
 *                 .description("Test description for a policy.")
 *                 .rules(DeliveryRuleArgs.builder()
 *                     .actions(
 *                         DeliveryRuleCacheExpirationActionArgs.builder()
 *                             .name("CacheExpiration")
 *                             .parameters(CacheExpirationActionParametersArgs.builder()
 *                                 .cacheBehavior("Override")
 *                                 .cacheDuration("10:10:09")
 *                                 .cacheType("All")
 *                                 .typeName("DeliveryRuleCacheExpirationActionParameters")
 *                                 .build())
 *                             .build(),
 *                         DeliveryRuleCacheExpirationActionArgs.builder()
 *                             .name("ModifyResponseHeader")
 *                             .parameters(CacheExpirationActionParametersArgs.builder()
 *                                 .headerAction("Overwrite")
 *                                 .headerName("Access-Control-Allow-Origin")
 *                                 .typeName("DeliveryRuleHeaderActionParameters")
 *                                 .value("*")
 *                                 .build())
 *                             .build(),
 *                         DeliveryRuleCacheExpirationActionArgs.builder()
 *                             .name("ModifyRequestHeader")
 *                             .parameters(CacheExpirationActionParametersArgs.builder()
 *                                 .headerAction("Overwrite")
 *                                 .headerName("Accept-Encoding")
 *                                 .typeName("DeliveryRuleHeaderActionParameters")
 *                                 .value("gzip")
 *                                 .build())
 *                             .build())
 *                     .conditions(DeliveryRuleRemoteAddressConditionArgs.builder()
 *                         .name("RemoteAddress")
 *                         .parameters(RemoteAddressMatchConditionParametersArgs.builder()
 *                             .matchValues(
 *                                 "192.168.1.0/24",
 *                                 "10.0.0.0/24")
 *                             .negateCondition(true)
 *                             .operator("IPMatch")
 *                             .typeName("DeliveryRuleRemoteAddressConditionParameters")
 *                             .build())
 *                         .build())
 *                     .name("rule1")
 *                     .order(1)
 *                     .build())
 *                 .build())
 *             .endpointName("endpoint1")
 *             .isCompressionEnabled(true)
 *             .isHttpAllowed(true)
 *             .isHttpsAllowed(true)
 *             .location("WestUs")
 *             .originGroups(DeepCreatedOriginGroupArgs.builder()
 *                 .healthProbeSettings(HealthProbeParametersArgs.builder()
 *                     .probeIntervalInSeconds(120)
 *                     .probePath("/health.aspx")
 *                     .probeProtocol("Http")
 *                     .probeRequestType("GET")
 *                     .build())
 *                 .name("originGroup1")
 *                 .origins(
 *                     ResourceReferenceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1")
 *                         .build(),
 *                     ResourceReferenceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin2")
 *                         .build())
 *                 .responseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParametersArgs.builder()
 *                     .responseBasedDetectedErrorTypes("TcpErrorsOnly")
 *                     .responseBasedFailoverThresholdPercentage(10)
 *                     .build())
 *                 .build())
 *             .originHostHeader("www.bing.com")
 *             .originPath("/photos")
 *             .origins(
 *                 DeepCreatedOriginArgs.builder()
 *                     .enabled(true)
 *                     .hostName("www.someDomain1.net")
 *                     .httpPort(80)
 *                     .httpsPort(443)
 *                     .name("origin1")
 *                     .originHostHeader("www.someDomain1.net")
 *                     .priority(1)
 *                     .weight(50)
 *                     .build(),
 *                 DeepCreatedOriginArgs.builder()
 *                     .enabled(true)
 *                     .hostName("www.someDomain2.net")
 *                     .httpPort(80)
 *                     .httpsPort(443)
 *                     .name("origin2")
 *                     .originHostHeader("www.someDomain2.net")
 *                     .priority(2)
 *                     .weight(50)
 *                     .build())
 *             .profileName("profile1")
 *             .queryStringCachingBehavior("BypassCaching")
 *             .resourceGroupName("RG")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Endpoint endpoint4899 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}
 * ```
 * @property contentTypesToCompress List of content types on which compression applies. The value should be a valid MIME type.
 * @property defaultOriginGroup A reference to the origin group.
 * @property deliveryPolicy A policy that specifies the delivery rules to be used for an endpoint.
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property geoFilters List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
 * @property isCompressionEnabled Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
 * @property isHttpAllowed Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
 * @property isHttpsAllowed Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
 * @property location Resource location.
 * @property optimizationType Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
 * @property originGroups The origin groups comprising of origins that are used for load balancing the traffic based on availability.
 * @property originHostHeader The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
 * @property originPath A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
 * @property origins The source of the content being delivered via CDN.
 * @property probePath Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is only relevant when using a single origin.
 * @property profileName Name of the CDN profile which is unique within the resource group.
 * @property queryStringCachingBehavior Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property tags Resource tags.
 * @property urlSigningKeys List of keys used to validate the signed URL hashes.
 * @property webApplicationFirewallPolicyLink Defines the Web Application Firewall policy for the endpoint (if applicable)
 */
public data class EndpointArgs(
    public val contentTypesToCompress: Output<List<String>>? = null,
    public val defaultOriginGroup: Output<ResourceReferenceArgs>? = null,
    public val deliveryPolicy: Output<EndpointPropertiesUpdateParametersDeliveryPolicyArgs>? = null,
    public val endpointName: Output<String>? = null,
    public val geoFilters: Output<List<GeoFilterArgs>>? = null,
    public val isCompressionEnabled: Output<Boolean>? = null,
    public val isHttpAllowed: Output<Boolean>? = null,
    public val isHttpsAllowed: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val optimizationType: Output<Either<String, OptimizationType>>? = null,
    public val originGroups: Output<List<DeepCreatedOriginGroupArgs>>? = null,
    public val originHostHeader: Output<String>? = null,
    public val originPath: Output<String>? = null,
    public val origins: Output<List<DeepCreatedOriginArgs>>? = null,
    public val probePath: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val queryStringCachingBehavior: Output<QueryStringCachingBehavior>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val urlSigningKeys: Output<List<UrlSigningKeyArgs>>? = null,
    public val webApplicationFirewallPolicyLink: Output<EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.EndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.EndpointArgs =
        com.pulumi.azurenative.cdn.EndpointArgs.builder()
            .contentTypesToCompress(
                contentTypesToCompress?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .defaultOriginGroup(
                defaultOriginGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deliveryPolicy(deliveryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .geoFilters(
                geoFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isCompressionEnabled(isCompressionEnabled?.applyValue({ args0 -> args0 }))
            .isHttpAllowed(isHttpAllowed?.applyValue({ args0 -> args0 }))
            .isHttpsAllowed(isHttpsAllowed?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .optimizationType(
                optimizationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .originGroups(
                originGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .originHostHeader(originHostHeader?.applyValue({ args0 -> args0 }))
            .originPath(originPath?.applyValue({ args0 -> args0 }))
            .origins(
                origins?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .probePath(probePath?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .queryStringCachingBehavior(
                queryStringCachingBehavior?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .urlSigningKeys(
                urlSigningKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .webApplicationFirewallPolicyLink(
                webApplicationFirewallPolicyLink?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var contentTypesToCompress: Output<List<String>>? = null

    private var defaultOriginGroup: Output<ResourceReferenceArgs>? = null

    private var deliveryPolicy: Output<EndpointPropertiesUpdateParametersDeliveryPolicyArgs>? = null

    private var endpointName: Output<String>? = null

    private var geoFilters: Output<List<GeoFilterArgs>>? = null

    private var isCompressionEnabled: Output<Boolean>? = null

    private var isHttpAllowed: Output<Boolean>? = null

    private var isHttpsAllowed: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var optimizationType: Output<Either<String, OptimizationType>>? = null

    private var originGroups: Output<List<DeepCreatedOriginGroupArgs>>? = null

    private var originHostHeader: Output<String>? = null

    private var originPath: Output<String>? = null

    private var origins: Output<List<DeepCreatedOriginArgs>>? = null

    private var probePath: Output<String>? = null

    private var profileName: Output<String>? = null

    private var queryStringCachingBehavior: Output<QueryStringCachingBehavior>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var urlSigningKeys: Output<List<UrlSigningKeyArgs>>? = null

    private var webApplicationFirewallPolicyLink:
        Output<EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs>? = null

    /**
     * @param value List of content types on which compression applies. The value should be a valid MIME type.
     */
    @JvmName("gsukmtxspbjugarh")
    public suspend fun contentTypesToCompress(`value`: Output<List<String>>) {
        this.contentTypesToCompress = value
    }

    @JvmName("utmlcvlcqkgenusf")
    public suspend fun contentTypesToCompress(vararg values: Output<String>) {
        this.contentTypesToCompress = Output.all(values.asList())
    }

    /**
     * @param values List of content types on which compression applies. The value should be a valid MIME type.
     */
    @JvmName("wsnuwqxxlmlfvdio")
    public suspend fun contentTypesToCompress(values: List<Output<String>>) {
        this.contentTypesToCompress = Output.all(values)
    }

    /**
     * @param value A reference to the origin group.
     */
    @JvmName("qtodieydmuwyojvd")
    public suspend fun defaultOriginGroup(`value`: Output<ResourceReferenceArgs>) {
        this.defaultOriginGroup = value
    }

    /**
     * @param value A policy that specifies the delivery rules to be used for an endpoint.
     */
    @JvmName("xphudbhiuenjqopt")
    public suspend fun deliveryPolicy(`value`: Output<EndpointPropertiesUpdateParametersDeliveryPolicyArgs>) {
        this.deliveryPolicy = value
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("mupxxlgqrgdfrmuk")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
     */
    @JvmName("rblypkylgdceddyl")
    public suspend fun geoFilters(`value`: Output<List<GeoFilterArgs>>) {
        this.geoFilters = value
    }

    @JvmName("ngwsschbhhvrokpv")
    public suspend fun geoFilters(vararg values: Output<GeoFilterArgs>) {
        this.geoFilters = Output.all(values.asList())
    }

    /**
     * @param values List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
     */
    @JvmName("bxcldfkcanaiudpw")
    public suspend fun geoFilters(values: List<Output<GeoFilterArgs>>) {
        this.geoFilters = Output.all(values)
    }

    /**
     * @param value Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
     */
    @JvmName("audjfeadidydkylp")
    public suspend fun isCompressionEnabled(`value`: Output<Boolean>) {
        this.isCompressionEnabled = value
    }

    /**
     * @param value Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    @JvmName("yuqlydmxioxhvvxg")
    public suspend fun isHttpAllowed(`value`: Output<Boolean>) {
        this.isHttpAllowed = value
    }

    /**
     * @param value Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    @JvmName("tamcnxgrwcetcyiq")
    public suspend fun isHttpsAllowed(`value`: Output<Boolean>) {
        this.isHttpsAllowed = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xlwrfjgdelagxqag")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
     */
    @JvmName("iqcgnbgcfbafcbmr")
    public suspend fun optimizationType(`value`: Output<Either<String, OptimizationType>>) {
        this.optimizationType = value
    }

    /**
     * @param value The origin groups comprising of origins that are used for load balancing the traffic based on availability.
     */
    @JvmName("epwgfsugnxmgtmxf")
    public suspend fun originGroups(`value`: Output<List<DeepCreatedOriginGroupArgs>>) {
        this.originGroups = value
    }

    @JvmName("kwyqdxmjsqyfsyqa")
    public suspend fun originGroups(vararg values: Output<DeepCreatedOriginGroupArgs>) {
        this.originGroups = Output.all(values.asList())
    }

    /**
     * @param values The origin groups comprising of origins that are used for load balancing the traffic based on availability.
     */
    @JvmName("nplpvbejqolcvuja")
    public suspend fun originGroups(values: List<Output<DeepCreatedOriginGroupArgs>>) {
        this.originGroups = Output.all(values)
    }

    /**
     * @param value The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
     */
    @JvmName("lpyideoahgpighvf")
    public suspend fun originHostHeader(`value`: Output<String>) {
        this.originHostHeader = value
    }

    /**
     * @param value A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
     */
    @JvmName("cvvbalnmcyfpgxjt")
    public suspend fun originPath(`value`: Output<String>) {
        this.originPath = value
    }

    /**
     * @param value The source of the content being delivered via CDN.
     */
    @JvmName("rbwmnaxydaupplun")
    public suspend fun origins(`value`: Output<List<DeepCreatedOriginArgs>>) {
        this.origins = value
    }

    @JvmName("ijtenxlophknkdbl")
    public suspend fun origins(vararg values: Output<DeepCreatedOriginArgs>) {
        this.origins = Output.all(values.asList())
    }

    /**
     * @param values The source of the content being delivered via CDN.
     */
    @JvmName("tvpnjbpckkdsgqje")
    public suspend fun origins(values: List<Output<DeepCreatedOriginArgs>>) {
        this.origins = Output.all(values)
    }

    /**
     * @param value Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is only relevant when using a single origin.
     */
    @JvmName("rlplnjfunxfhprmn")
    public suspend fun probePath(`value`: Output<String>) {
        this.probePath = value
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("ekvyxhcsuduopngr")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL.
     */
    @JvmName("ltmhuowbpiiwxqgc")
    public suspend fun queryStringCachingBehavior(`value`: Output<QueryStringCachingBehavior>) {
        this.queryStringCachingBehavior = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("fnkebayemupeqyxo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eubbweydgsgyibsm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of keys used to validate the signed URL hashes.
     */
    @JvmName("kgmtklkmiryqfhoq")
    public suspend fun urlSigningKeys(`value`: Output<List<UrlSigningKeyArgs>>) {
        this.urlSigningKeys = value
    }

    @JvmName("cycavrkslgrsfnnh")
    public suspend fun urlSigningKeys(vararg values: Output<UrlSigningKeyArgs>) {
        this.urlSigningKeys = Output.all(values.asList())
    }

    /**
     * @param values List of keys used to validate the signed URL hashes.
     */
    @JvmName("donjdbwptsuvfgru")
    public suspend fun urlSigningKeys(values: List<Output<UrlSigningKeyArgs>>) {
        this.urlSigningKeys = Output.all(values)
    }

    /**
     * @param value Defines the Web Application Firewall policy for the endpoint (if applicable)
     */
    @JvmName("nhefoqtwwyrhuhgt")
    public suspend fun webApplicationFirewallPolicyLink(`value`: Output<EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs>) {
        this.webApplicationFirewallPolicyLink = value
    }

    /**
     * @param value List of content types on which compression applies. The value should be a valid MIME type.
     */
    @JvmName("yusovwiveflasoug")
    public suspend fun contentTypesToCompress(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypesToCompress = mapped
    }

    /**
     * @param values List of content types on which compression applies. The value should be a valid MIME type.
     */
    @JvmName("gsduewcyndjpxumg")
    public suspend fun contentTypesToCompress(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentTypesToCompress = mapped
    }

    /**
     * @param value A reference to the origin group.
     */
    @JvmName("umitxawpqksuqrfd")
    public suspend fun defaultOriginGroup(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultOriginGroup = mapped
    }

    /**
     * @param argument A reference to the origin group.
     */
    @JvmName("ihgfklejopyfpaqw")
    public suspend fun defaultOriginGroup(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultOriginGroup = mapped
    }

    /**
     * @param value A policy that specifies the delivery rules to be used for an endpoint.
     */
    @JvmName("advsigmvyjbtpynh")
    public suspend fun deliveryPolicy(`value`: EndpointPropertiesUpdateParametersDeliveryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryPolicy = mapped
    }

    /**
     * @param argument A policy that specifies the delivery rules to be used for an endpoint.
     */
    @JvmName("tiwocptfxokslpei")
    public suspend fun deliveryPolicy(argument: suspend EndpointPropertiesUpdateParametersDeliveryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointPropertiesUpdateParametersDeliveryPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deliveryPolicy = mapped
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("oleupdbhyjxdbqww")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
     */
    @JvmName("ujqvovsewuaasuvo")
    public suspend fun geoFilters(`value`: List<GeoFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoFilters = mapped
    }

    /**
     * @param argument List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
     */
    @JvmName("xpaxpjndnwsfiwvo")
    public suspend fun geoFilters(argument: List<suspend GeoFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GeoFilterArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.geoFilters = mapped
    }

    /**
     * @param argument List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
     */
    @JvmName("knxnmijgtkypgauw")
    public suspend fun geoFilters(vararg argument: suspend GeoFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GeoFilterArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.geoFilters = mapped
    }

    /**
     * @param argument List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
     */
    @JvmName("ynlyvycjvaieylno")
    public suspend fun geoFilters(argument: suspend GeoFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GeoFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.geoFilters = mapped
    }

    /**
     * @param values List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
     */
    @JvmName("ikrnwckasrrcmiwm")
    public suspend fun geoFilters(vararg values: GeoFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoFilters = mapped
    }

    /**
     * @param value Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
     */
    @JvmName("rndauwvqdhhamruk")
    public suspend fun isCompressionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCompressionEnabled = mapped
    }

    /**
     * @param value Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    @JvmName("wlcrrmfnkwnsafck")
    public suspend fun isHttpAllowed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isHttpAllowed = mapped
    }

    /**
     * @param value Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    @JvmName("rthixjwtigdcqtfr")
    public suspend fun isHttpsAllowed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isHttpsAllowed = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ichjebftdhrvltwh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
     */
    @JvmName("nfldcyogqlfpbqdj")
    public suspend fun optimizationType(`value`: Either<String, OptimizationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizationType = mapped
    }

    /**
     * @param value Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
     */
    @JvmName("bvkxfqpuecrdypeo")
    public fun optimizationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OptimizationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optimizationType = mapped
    }

    /**
     * @param value Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization.
     */
    @JvmName("akqlyewxnifdmctm")
    public fun optimizationType(`value`: OptimizationType) {
        val toBeMapped = Either.ofRight<String, OptimizationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optimizationType = mapped
    }

    /**
     * @param value The origin groups comprising of origins that are used for load balancing the traffic based on availability.
     */
    @JvmName("exihiqltwqcydife")
    public suspend fun originGroups(`value`: List<DeepCreatedOriginGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originGroups = mapped
    }

    /**
     * @param argument The origin groups comprising of origins that are used for load balancing the traffic based on availability.
     */
    @JvmName("fsqujqsfujcrdgij")
    public suspend fun originGroups(argument: List<suspend DeepCreatedOriginGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeepCreatedOriginGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.originGroups = mapped
    }

    /**
     * @param argument The origin groups comprising of origins that are used for load balancing the traffic based on availability.
     */
    @JvmName("xxfgxmtetocysevp")
    public suspend fun originGroups(vararg argument: suspend DeepCreatedOriginGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeepCreatedOriginGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.originGroups = mapped
    }

    /**
     * @param argument The origin groups comprising of origins that are used for load balancing the traffic based on availability.
     */
    @JvmName("qefwvtdynxdhsvac")
    public suspend fun originGroups(argument: suspend DeepCreatedOriginGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DeepCreatedOriginGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.originGroups = mapped
    }

    /**
     * @param values The origin groups comprising of origins that are used for load balancing the traffic based on availability.
     */
    @JvmName("lpmuwsfhjwcyqprc")
    public suspend fun originGroups(vararg values: DeepCreatedOriginGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originGroups = mapped
    }

    /**
     * @param value The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
     */
    @JvmName("ohjawfqmkpdvajir")
    public suspend fun originHostHeader(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originHostHeader = mapped
    }

    /**
     * @param value A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
     */
    @JvmName("jgdjdnumnlvfjqmg")
    public suspend fun originPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originPath = mapped
    }

    /**
     * @param value The source of the content being delivered via CDN.
     */
    @JvmName("jswqdwxwrspntdwr")
    public suspend fun origins(`value`: List<DeepCreatedOriginArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    /**
     * @param argument The source of the content being delivered via CDN.
     */
    @JvmName("lcpnujhhkjghcwss")
    public suspend fun origins(argument: List<suspend DeepCreatedOriginArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeepCreatedOriginArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param argument The source of the content being delivered via CDN.
     */
    @JvmName("blgutlvgdhsuspto")
    public suspend fun origins(vararg argument: suspend DeepCreatedOriginArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeepCreatedOriginArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param argument The source of the content being delivered via CDN.
     */
    @JvmName("uxbxoqxknsjlmome")
    public suspend fun origins(argument: suspend DeepCreatedOriginArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DeepCreatedOriginArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.origins = mapped
    }

    /**
     * @param values The source of the content being delivered via CDN.
     */
    @JvmName("cdgotdtsiuvpwvox")
    public suspend fun origins(vararg values: DeepCreatedOriginArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    /**
     * @param value Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is only relevant when using a single origin.
     */
    @JvmName("muxbxffxriobgkuw")
    public suspend fun probePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probePath = mapped
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("rrfypyulkmnqdntd")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL.
     */
    @JvmName("ggmmdbybixaprgrm")
    public suspend fun queryStringCachingBehavior(`value`: QueryStringCachingBehavior?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringCachingBehavior = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("rytujrhhgukrqdpm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hctdexigosmiagoq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wufqyrpkqvehjbuq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of keys used to validate the signed URL hashes.
     */
    @JvmName("pjgywxrfcgoxfrqt")
    public suspend fun urlSigningKeys(`value`: List<UrlSigningKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlSigningKeys = mapped
    }

    /**
     * @param argument List of keys used to validate the signed URL hashes.
     */
    @JvmName("svyexxpcdaxaxtue")
    public suspend fun urlSigningKeys(argument: List<suspend UrlSigningKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UrlSigningKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.urlSigningKeys = mapped
    }

    /**
     * @param argument List of keys used to validate the signed URL hashes.
     */
    @JvmName("ceppvumgoiaodfdi")
    public suspend fun urlSigningKeys(vararg argument: suspend UrlSigningKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UrlSigningKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.urlSigningKeys = mapped
    }

    /**
     * @param argument List of keys used to validate the signed URL hashes.
     */
    @JvmName("iykacdayetbtjcfx")
    public suspend fun urlSigningKeys(argument: suspend UrlSigningKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UrlSigningKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.urlSigningKeys = mapped
    }

    /**
     * @param values List of keys used to validate the signed URL hashes.
     */
    @JvmName("eyxtgcvntjrdakch")
    public suspend fun urlSigningKeys(vararg values: UrlSigningKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urlSigningKeys = mapped
    }

    /**
     * @param value Defines the Web Application Firewall policy for the endpoint (if applicable)
     */
    @JvmName("uoswlljbdckdmfsv")
    public suspend fun webApplicationFirewallPolicyLink(`value`: EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webApplicationFirewallPolicyLink = mapped
    }

    /**
     * @param argument Defines the Web Application Firewall policy for the endpoint (if applicable)
     */
    @JvmName("brucalccifwrsbcb")
    public suspend fun webApplicationFirewallPolicyLink(argument: suspend EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.webApplicationFirewallPolicyLink = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        contentTypesToCompress = contentTypesToCompress,
        defaultOriginGroup = defaultOriginGroup,
        deliveryPolicy = deliveryPolicy,
        endpointName = endpointName,
        geoFilters = geoFilters,
        isCompressionEnabled = isCompressionEnabled,
        isHttpAllowed = isHttpAllowed,
        isHttpsAllowed = isHttpsAllowed,
        location = location,
        optimizationType = optimizationType,
        originGroups = originGroups,
        originHostHeader = originHostHeader,
        originPath = originPath,
        origins = origins,
        probePath = probePath,
        profileName = profileName,
        queryStringCachingBehavior = queryStringCachingBehavior,
        resourceGroupName = resourceGroupName,
        tags = tags,
        urlSigningKeys = urlSigningKeys,
        webApplicationFirewallPolicyLink = webApplicationFirewallPolicyLink,
    )
}
