@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Origin].
 */
@PulumiTagMarker
public class OriginResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OriginArgs = OriginArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OriginArgsBuilder.() -> Unit) {
        val builder = OriginArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Origin {
        val builtJavaResource = com.pulumi.azurenative.cdn.Origin(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Origin(builtJavaResource)
    }
}

/**
 * CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Origins_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var origin = new AzureNative.Cdn.Origin("origin", new()
 *     {
 *         Enabled = true,
 *         EndpointName = "endpoint1",
 *         HostName = "www.someDomain.net",
 *         HttpPort = 80,
 *         HttpsPort = 443,
 *         OriginHostHeader = "www.someDomain.net",
 *         OriginName = "www-someDomain-net",
 *         Priority = 1,
 *         PrivateLinkApprovalMessage = "Please approve the connection request for this Private Link",
 *         PrivateLinkLocation = "eastus",
 *         PrivateLinkResourceId = "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         Weight = 50,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewOrigin(ctx, "origin", &cdn.OriginArgs{
 * 			Enabled:                    pulumi.Bool(true),
 * 			EndpointName:               pulumi.String("endpoint1"),
 * 			HostName:                   pulumi.String("www.someDomain.net"),
 * 			HttpPort:                   pulumi.Int(80),
 * 			HttpsPort:                  pulumi.Int(443),
 * 			OriginHostHeader:           pulumi.String("www.someDomain.net"),
 * 			OriginName:                 pulumi.String("www-someDomain-net"),
 * 			Priority:                   pulumi.Int(1),
 * 			PrivateLinkApprovalMessage: pulumi.String("Please approve the connection request for this Private Link"),
 * 			PrivateLinkLocation:        pulumi.String("eastus"),
 * 			PrivateLinkResourceId:      pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1"),
 * 			ProfileName:                pulumi.String("profile1"),
 * 			ResourceGroupName:          pulumi.String("RG"),
 * 			Weight:                     pulumi.Int(50),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Origin;
 * import com.pulumi.azurenative.cdn.OriginArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var origin = new Origin("origin", OriginArgs.builder()
 *             .enabled(true)
 *             .endpointName("endpoint1")
 *             .hostName("www.someDomain.net")
 *             .httpPort(80)
 *             .httpsPort(443)
 *             .originHostHeader("www.someDomain.net")
 *             .originName("www-someDomain-net")
 *             .priority(1)
 *             .privateLinkApprovalMessage("Please approve the connection request for this Private Link")
 *             .privateLinkLocation("eastus")
 *             .privateLinkResourceId("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .weight(50)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Origin www-someDomain-net /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins/{originName}
 * ```
 */
public class Origin internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.Origin,
) : KotlinCustomResource(javaResource, OriginMapper) {
    /**
     * Origin is enabled for load balancing or not
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * The value of the HTTP port. Must be between 1 and 65535.
     */
    public val httpPort: Output<Int>?
        get() = javaResource.httpPort().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The value of the HTTPS port. Must be between 1 and 65535.
     */
    public val httpsPort: Output<Int>?
        get() = javaResource.httpsPort().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
     */
    public val originHostHeader: Output<String>?
        get() = javaResource.originHostHeader().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The approval status for the connection to the Private Link
     */
    public val privateEndpointStatus: Output<String>
        get() = javaResource.privateEndpointStatus().applyValue({ args0 -> args0 })

    /**
     * The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
     */
    public val privateLinkAlias: Output<String>?
        get() = javaResource.privateLinkAlias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A custom message to be included in the approval request to connect to the Private Link.
     */
    public val privateLinkApprovalMessage: Output<String>?
        get() = javaResource.privateLinkApprovalMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
     */
    public val privateLinkLocation: Output<String>?
        get() = javaResource.privateLinkLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
     */
    public val privateLinkResourceId: Output<String>?
        get() = javaResource.privateLinkResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning status of the origin.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource status of the origin.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
     */
    public val weight: Output<Int>?
        get() = javaResource.weight().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object OriginMapper : ResourceMapper<Origin> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.Origin::class == javaResource::class

    override fun map(javaResource: Resource): Origin = Origin(
        javaResource as
            com.pulumi.azurenative.cdn.Origin,
    )
}

/**
 * @see [Origin].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Origin].
 */
public suspend fun origin(name: String, block: suspend OriginResourceBuilder.() -> Unit): Origin {
    val builder = OriginResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Origin].
 * @param name The _unique_ name of the resulting resource.
 */
public fun origin(name: String): Origin {
    val builder = OriginResourceBuilder()
    builder.name(name)
    return builder.build()
}
