@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.OriginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Origins_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var origin = new AzureNative.Cdn.Origin("origin", new()
 *     {
 *         Enabled = true,
 *         EndpointName = "endpoint1",
 *         HostName = "www.someDomain.net",
 *         HttpPort = 80,
 *         HttpsPort = 443,
 *         OriginHostHeader = "www.someDomain.net",
 *         OriginName = "www-someDomain-net",
 *         Priority = 1,
 *         PrivateLinkApprovalMessage = "Please approve the connection request for this Private Link",
 *         PrivateLinkLocation = "eastus",
 *         PrivateLinkResourceId = "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         Weight = 50,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewOrigin(ctx, "origin", &cdn.OriginArgs{
 * 			Enabled:                    pulumi.Bool(true),
 * 			EndpointName:               pulumi.String("endpoint1"),
 * 			HostName:                   pulumi.String("www.someDomain.net"),
 * 			HttpPort:                   pulumi.Int(80),
 * 			HttpsPort:                  pulumi.Int(443),
 * 			OriginHostHeader:           pulumi.String("www.someDomain.net"),
 * 			OriginName:                 pulumi.String("www-someDomain-net"),
 * 			Priority:                   pulumi.Int(1),
 * 			PrivateLinkApprovalMessage: pulumi.String("Please approve the connection request for this Private Link"),
 * 			PrivateLinkLocation:        pulumi.String("eastus"),
 * 			PrivateLinkResourceId:      pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1"),
 * 			ProfileName:                pulumi.String("profile1"),
 * 			ResourceGroupName:          pulumi.String("RG"),
 * 			Weight:                     pulumi.Int(50),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Origin;
 * import com.pulumi.azurenative.cdn.OriginArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var origin = new Origin("origin", OriginArgs.builder()
 *             .enabled(true)
 *             .endpointName("endpoint1")
 *             .hostName("www.someDomain.net")
 *             .httpPort(80)
 *             .httpsPort(443)
 *             .originHostHeader("www.someDomain.net")
 *             .originName("www-someDomain-net")
 *             .priority(1)
 *             .privateLinkApprovalMessage("Please approve the connection request for this Private Link")
 *             .privateLinkLocation("eastus")
 *             .privateLinkResourceId("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .weight(50)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Origin www-someDomain-net /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins/{originName}
 * ```
 * @property enabled Origin is enabled for load balancing or not
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property hostName The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
 * @property httpPort The value of the HTTP port. Must be between 1 and 65535.
 * @property httpsPort The value of the HTTPS port. Must be between 1 and 65535.
 * @property originHostHeader The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
 * @property originName Name of the origin that is unique within the endpoint.
 * @property priority Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
 * @property privateLinkAlias The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
 * @property privateLinkApprovalMessage A custom message to be included in the approval request to connect to the Private Link.
 * @property privateLinkLocation The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
 * @property privateLinkResourceId The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
 * @property profileName Name of the CDN profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property weight Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
 */
public data class OriginArgs(
    public val enabled: Output<Boolean>? = null,
    public val endpointName: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val httpPort: Output<Int>? = null,
    public val httpsPort: Output<Int>? = null,
    public val originHostHeader: Output<String>? = null,
    public val originName: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val privateLinkAlias: Output<String>? = null,
    public val privateLinkApprovalMessage: Output<String>? = null,
    public val privateLinkLocation: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.OriginArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.OriginArgs =
        com.pulumi.azurenative.cdn.OriginArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .httpPort(httpPort?.applyValue({ args0 -> args0 }))
            .httpsPort(httpsPort?.applyValue({ args0 -> args0 }))
            .originHostHeader(originHostHeader?.applyValue({ args0 -> args0 }))
            .originName(originName?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .privateLinkAlias(privateLinkAlias?.applyValue({ args0 -> args0 }))
            .privateLinkApprovalMessage(privateLinkApprovalMessage?.applyValue({ args0 -> args0 }))
            .privateLinkLocation(privateLinkLocation?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OriginArgs].
 */
@PulumiTagMarker
public class OriginArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var endpointName: Output<String>? = null

    private var hostName: Output<String>? = null

    private var httpPort: Output<Int>? = null

    private var httpsPort: Output<Int>? = null

    private var originHostHeader: Output<String>? = null

    private var originName: Output<String>? = null

    private var priority: Output<Int>? = null

    private var privateLinkAlias: Output<String>? = null

    private var privateLinkApprovalMessage: Output<String>? = null

    private var privateLinkLocation: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value Origin is enabled for load balancing or not
     */
    @JvmName("trxejkcjuljfefwb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("fcdqgftfstjsnubi")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
     */
    @JvmName("oaydobceuuioaigi")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The value of the HTTP port. Must be between 1 and 65535.
     */
    @JvmName("jpiykftfnlbwbbvr")
    public suspend fun httpPort(`value`: Output<Int>) {
        this.httpPort = value
    }

    /**
     * @param value The value of the HTTPS port. Must be between 1 and 65535.
     */
    @JvmName("dejrfqsixfkkxqia")
    public suspend fun httpsPort(`value`: Output<Int>) {
        this.httpsPort = value
    }

    /**
     * @param value The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
     */
    @JvmName("vsclpaompmsuxxnq")
    public suspend fun originHostHeader(`value`: Output<String>) {
        this.originHostHeader = value
    }

    /**
     * @param value Name of the origin that is unique within the endpoint.
     */
    @JvmName("tmolnbpxdhifhydx")
    public suspend fun originName(`value`: Output<String>) {
        this.originName = value
    }

    /**
     * @param value Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
     */
    @JvmName("hwnwlifwcwmcloeb")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
     */
    @JvmName("btcyoshvldhfeluy")
    public suspend fun privateLinkAlias(`value`: Output<String>) {
        this.privateLinkAlias = value
    }

    /**
     * @param value A custom message to be included in the approval request to connect to the Private Link.
     */
    @JvmName("grqiubyogkswhvrd")
    public suspend fun privateLinkApprovalMessage(`value`: Output<String>) {
        this.privateLinkApprovalMessage = value
    }

    /**
     * @param value The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
     */
    @JvmName("eugybonkrsvqkuea")
    public suspend fun privateLinkLocation(`value`: Output<String>) {
        this.privateLinkLocation = value
    }

    /**
     * @param value The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
     */
    @JvmName("vcblyltwrrkvawer")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("eamjvwvnbmnfmgrv")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("xskudpvsrlgbhuup")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
     */
    @JvmName("exqedicnwdigtqgc")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value Origin is enabled for load balancing or not
     */
    @JvmName("dxwmfhmuomikkpuc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("ielqumklplcusjcv")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
     */
    @JvmName("kbuafsfgeklpjpfv")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The value of the HTTP port. Must be between 1 and 65535.
     */
    @JvmName("amtlqorqyqnmtjtt")
    public suspend fun httpPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPort = mapped
    }

    /**
     * @param value The value of the HTTPS port. Must be between 1 and 65535.
     */
    @JvmName("uotouyxahfytwsmp")
    public suspend fun httpsPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsPort = mapped
    }

    /**
     * @param value The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
     */
    @JvmName("jcmrdacqijtvqxfy")
    public suspend fun originHostHeader(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originHostHeader = mapped
    }

    /**
     * @param value Name of the origin that is unique within the endpoint.
     */
    @JvmName("iajuwfirhwxhumnd")
    public suspend fun originName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originName = mapped
    }

    /**
     * @param value Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
     */
    @JvmName("hvfgjvembqvtojyn")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
     */
    @JvmName("ngeisveaqnpsoffw")
    public suspend fun privateLinkAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkAlias = mapped
    }

    /**
     * @param value A custom message to be included in the approval request to connect to the Private Link.
     */
    @JvmName("ymamoojayxwpqcej")
    public suspend fun privateLinkApprovalMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkApprovalMessage = mapped
    }

    /**
     * @param value The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
     */
    @JvmName("xmnepxkmfifhhqsi")
    public suspend fun privateLinkLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkLocation = mapped
    }

    /**
     * @param value The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
     */
    @JvmName("cwdfdxqrnamimbqv")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value Name of the CDN profile which is unique within the resource group.
     */
    @JvmName("umuhjtarrnrwxlcp")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("pvrarmekiejflxva")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
     */
    @JvmName("ckryodvlxofcsnsr")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): OriginArgs = OriginArgs(
        enabled = enabled,
        endpointName = endpointName,
        hostName = hostName,
        httpPort = httpPort,
        httpsPort = httpsPort,
        originHostHeader = originHostHeader,
        originName = originName,
        priority = priority,
        privateLinkAlias = privateLinkAlias,
        privateLinkApprovalMessage = privateLinkApprovalMessage,
        privateLinkLocation = privateLinkLocation,
        privateLinkResourceId = privateLinkResourceId,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        weight = weight,
    )
}
