@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.CdnEndpointResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.CustomRuleListResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.ManagedRuleSetListResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.PolicySettingsResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.RateLimitRuleListResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.cdn.kotlin.outputs.CdnEndpointResponse.Companion.toKotlin as cdnEndpointResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.CustomRuleListResponse.Companion.toKotlin as customRuleListResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.ManagedRuleSetListResponse.Companion.toKotlin as managedRuleSetListResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.PolicySettingsResponse.Companion.toKotlin as policySettingsResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.RateLimitRuleListResponse.Companion.toKotlin as rateLimitRuleListResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.azurenative.cdn.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Defines web application firewall policy for Azure CDN.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Creates specific policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.Cdn.Policy("policy", new()
 *     {
 *         CustomRules = new AzureNative.Cdn.Inputs.CustomRuleListArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.CustomRuleArgs
 *                 {
 *                     Action = AzureNative.Cdn.ActionType.Block,
 *                     EnabledState = AzureNative.Cdn.CustomRuleEnabledState.Enabled,
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "CH",
 *                             },
 *                             MatchVariable = AzureNative.Cdn.WafMatchVariable.RemoteAddr,
 *                             NegateCondition = false,
 *                             Operator = AzureNative.Cdn.Operator.GeoMatch,
 *                             Transforms = new() { },
 *                         },
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "windows",
 *                             },
 *                             MatchVariable = AzureNative.Cdn.WafMatchVariable.RequestHeader,
 *                             NegateCondition = false,
 *                             Operator = AzureNative.Cdn.Operator.Contains,
 *                             Selector = "UserAgent",
 *                             Transforms = new() { },
 *                         },
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "<?php",
 *                                 "?>",
 *                             },
 *                             MatchVariable = AzureNative.Cdn.WafMatchVariable.QueryString,
 *                             NegateCondition = false,
 *                             Operator = AzureNative.Cdn.Operator.Contains,
 *                             Selector = "search",
 *                             Transforms = new[]
 *                             {
 *                                 AzureNative.Cdn.TransformType.UrlDecode,
 *                                 AzureNative.Cdn.TransformType.Lowercase,
 *                             },
 *                         },
 *                     },
 *                     Name = "CustomRule1",
 *                     Priority = 2,
 *                 },
 *             },
 *         },
 *         Location = "global",
 *         ManagedRules = new AzureNative.Cdn.Inputs.ManagedRuleSetListArgs
 *         {
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.ManagedRuleSetArgs
 *                 {
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.ManagedRuleGroupOverrideArgs
 *                         {
 *                             RuleGroupName = "Group1",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Cdn.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = AzureNative.Cdn.ActionType.Redirect,
 *                                     EnabledState = AzureNative.Cdn.ManagedRuleEnabledState.Enabled,
 *                                     RuleId = "GROUP1-0001",
 *                                 },
 *                                 new AzureNative.Cdn.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     EnabledState = AzureNative.Cdn.ManagedRuleEnabledState.Disabled,
 *                                     RuleId = "GROUP1-0002",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetType = "DefaultRuleSet",
 *                     RuleSetVersion = "preview-1.0",
 *                 },
 *             },
 *         },
 *         PolicyName = "MicrosoftCdnWafPolicy",
 *         PolicySettings = new AzureNative.Cdn.Inputs.PolicySettingsArgs
 *         {
 *             DefaultCustomBlockResponseBody = "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
 *             DefaultCustomBlockResponseStatusCode = 200,
 *             DefaultRedirectUrl = "http://www.bing.com",
 *         },
 *         RateLimitRules = new AzureNative.Cdn.Inputs.RateLimitRuleListArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.RateLimitRuleArgs
 *                 {
 *                     Action = AzureNative.Cdn.ActionType.Block,
 *                     EnabledState = AzureNative.Cdn.CustomRuleEnabledState.Enabled,
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.MatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "192.168.1.0/24",
 *                                 "10.0.0.0/24",
 *                             },
 *                             MatchVariable = AzureNative.Cdn.WafMatchVariable.RemoteAddr,
 *                             NegateCondition = false,
 *                             Operator = AzureNative.Cdn.Operator.IPMatch,
 *                             Transforms = new() { },
 *                         },
 *                     },
 *                     Name = "RateLimitRule1",
 *                     Priority = 1,
 *                     RateLimitDurationInMinutes = 0,
 *                     RateLimitThreshold = 1000,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Cdn.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Cdn.SkuName.Standard_Microsoft,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewPolicy(ctx, "policy", &cdn.PolicyArgs{
 * 			CustomRules: &cdn.CustomRuleListArgs{
 * 				Rules: cdn.CustomRuleArray{
 * 					&cdn.CustomRuleArgs{
 * 						Action:       pulumi.String(cdn.ActionTypeBlock),
 * 						EnabledState: pulumi.String(cdn.CustomRuleEnabledStateEnabled),
 * 						MatchConditions: cdn.MatchConditionArray{
 * 							&cdn.MatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("CH"),
 * 								},
 * 								MatchVariable:   pulumi.String(cdn.WafMatchVariableRemoteAddr),
 * 								NegateCondition: pulumi.Bool(false),
 * 								Operator:        pulumi.String(cdn.OperatorGeoMatch),
 * 								Transforms:      pulumi.StringArray{},
 * 							},
 * 							&cdn.MatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("windows"),
 * 								},
 * 								MatchVariable:   pulumi.String(cdn.WafMatchVariableRequestHeader),
 * 								NegateCondition: pulumi.Bool(false),
 * 								Operator:        pulumi.String(cdn.OperatorContains),
 * 								Selector:        pulumi.String("UserAgent"),
 * 								Transforms:      pulumi.StringArray{},
 * 							},
 * 							&cdn.MatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("<?php"),
 * 									pulumi.String("?>"),
 * 								},
 * 								MatchVariable:   pulumi.String(cdn.WafMatchVariableQueryString),
 * 								NegateCondition: pulumi.Bool(false),
 * 								Operator:        pulumi.String(cdn.OperatorContains),
 * 								Selector:        pulumi.String("search"),
 * 								Transforms: pulumi.StringArray{
 * 									pulumi.String(cdn.TransformTypeUrlDecode),
 * 									pulumi.String(cdn.TransformTypeLowercase),
 * 								},
 * 							},
 * 						},
 * 						Name:     pulumi.String("CustomRule1"),
 * 						Priority: pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			ManagedRules: &cdn.ManagedRuleSetListArgs{
 * 				ManagedRuleSets: cdn.ManagedRuleSetArray{
 * 					&cdn.ManagedRuleSetArgs{
 * 						RuleGroupOverrides: cdn.ManagedRuleGroupOverrideArray{
 * 							&cdn.ManagedRuleGroupOverrideArgs{
 * 								RuleGroupName: pulumi.String("Group1"),
 * 								Rules: cdn.ManagedRuleOverrideArray{
 * 									&cdn.ManagedRuleOverrideArgs{
 * 										Action:       pulumi.String(cdn.ActionTypeRedirect),
 * 										EnabledState: pulumi.String(cdn.ManagedRuleEnabledStateEnabled),
 * 										RuleId:       pulumi.String("GROUP1-0001"),
 * 									},
 * 									&cdn.ManagedRuleOverrideArgs{
 * 										EnabledState: pulumi.String(cdn.ManagedRuleEnabledStateDisabled),
 * 										RuleId:       pulumi.String("GROUP1-0002"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						RuleSetType:    pulumi.String("DefaultRuleSet"),
 * 						RuleSetVersion: pulumi.String("preview-1.0"),
 * 					},
 * 				},
 * 			},
 * 			PolicyName: pulumi.String("MicrosoftCdnWafPolicy"),
 * 			PolicySettings: &cdn.PolicySettingsArgs{
 * 				DefaultCustomBlockResponseBody:       pulumi.String("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
 * 				DefaultCustomBlockResponseStatusCode: pulumi.Int(200),
 * 				DefaultRedirectUrl:                   pulumi.String("http://www.bing.com"),
 * 			},
 * 			RateLimitRules: &cdn.RateLimitRuleListArgs{
 * 				Rules: cdn.RateLimitRuleArray{
 * 					&cdn.RateLimitRuleArgs{
 * 						Action:       pulumi.String(cdn.ActionTypeBlock),
 * 						EnabledState: pulumi.String(cdn.CustomRuleEnabledStateEnabled),
 * 						MatchConditions: cdn.MatchConditionArray{
 * 							&cdn.MatchConditionArgs{
 * 								MatchValue: pulumi.StringArray{
 * 									pulumi.String("192.168.1.0/24"),
 * 									pulumi.String("10.0.0.0/24"),
 * 								},
 * 								MatchVariable:   pulumi.String(cdn.WafMatchVariableRemoteAddr),
 * 								NegateCondition: pulumi.Bool(false),
 * 								Operator:        pulumi.String(cdn.OperatorIPMatch),
 * 								Transforms:      pulumi.StringArray{},
 * 							},
 * 						},
 * 						Name:                       pulumi.String("RateLimitRule1"),
 * 						Priority:                   pulumi.Int(1),
 * 						RateLimitDurationInMinutes: pulumi.Int(0),
 * 						RateLimitThreshold:         pulumi.Int(1000),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &cdn.SkuArgs{
 * 				Name: pulumi.String(cdn.SkuName_Standard_Microsoft),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Policy;
 * import com.pulumi.azurenative.cdn.PolicyArgs;
 * import com.pulumi.azurenative.cdn.inputs.CustomRuleListArgs;
 * import com.pulumi.azurenative.cdn.inputs.ManagedRuleSetListArgs;
 * import com.pulumi.azurenative.cdn.inputs.PolicySettingsArgs;
 * import com.pulumi.azurenative.cdn.inputs.RateLimitRuleListArgs;
 * import com.pulumi.azurenative.cdn.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .customRules(CustomRuleListArgs.builder()
 *                 .rules(CustomRuleArgs.builder()
 *                     .action("Block")
 *                     .enabledState("Enabled")
 *                     .matchConditions(
 *                         MatchConditionArgs.builder()
 *                             .matchValue("CH")
 *                             .matchVariable("RemoteAddr")
 *                             .negateCondition(false)
 *                             .operator("GeoMatch")
 *                             .transforms()
 *                             .build(),
 *                         MatchConditionArgs.builder()
 *                             .matchValue("windows")
 *                             .matchVariable("RequestHeader")
 *                             .negateCondition(false)
 *                             .operator("Contains")
 *                             .selector("UserAgent")
 *                             .transforms()
 *                             .build(),
 *                         MatchConditionArgs.builder()
 *                             .matchValue(
 *                                 "<?php",
 *                                 "?>")
 *                             .matchVariable("QueryString")
 *                             .negateCondition(false)
 *                             .operator("Contains")
 *                             .selector("search")
 *                             .transforms(
 *                                 "UrlDecode",
 *                                 "Lowercase")
 *                             .build())
 *                     .name("CustomRule1")
 *                     .priority(2)
 *                     .build())
 *                 .build())
 *             .location("global")
 *             .managedRules(ManagedRuleSetListArgs.builder()
 *                 .managedRuleSets(ManagedRuleSetArgs.builder()
 *                     .ruleGroupOverrides(ManagedRuleGroupOverrideArgs.builder()
 *                         .ruleGroupName("Group1")
 *                         .rules(
 *                             ManagedRuleOverrideArgs.builder()
 *                                 .action("Redirect")
 *                                 .enabledState("Enabled")
 *                                 .ruleId("GROUP1-0001")
 *                                 .build(),
 *                             ManagedRuleOverrideArgs.builder()
 *                                 .enabledState("Disabled")
 *                                 .ruleId("GROUP1-0002")
 *                                 .build())
 *                         .build())
 *                     .ruleSetType("DefaultRuleSet")
 *                     .ruleSetVersion("preview-1.0")
 *                     .build())
 *                 .build())
 *             .policyName("MicrosoftCdnWafPolicy")
 *             .policySettings(PolicySettingsArgs.builder()
 *                 .defaultCustomBlockResponseBody("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==")
 *                 .defaultCustomBlockResponseStatusCode(200)
 *                 .defaultRedirectUrl("http://www.bing.com")
 *                 .build())
 *             .rateLimitRules(RateLimitRuleListArgs.builder()
 *                 .rules(RateLimitRuleArgs.builder()
 *                     .action("Block")
 *                     .enabledState("Enabled")
 *                     .matchConditions(MatchConditionArgs.builder()
 *                         .matchValue(
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24")
 *                         .matchVariable("RemoteAddr")
 *                         .negateCondition(false)
 *                         .operator("IPMatch")
 *                         .transforms()
 *                         .build())
 *                     .name("RateLimitRule1")
 *                     .priority(1)
 *                     .rateLimitDurationInMinutes(0)
 *                     .rateLimitThreshold(1000)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_Microsoft")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Policy MicrosoftCdnWafPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/cdnWebApplicationFirewallPolicies/{policyName}
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * Describes custom rules inside the policy.
     */
    public val customRules: Output<CustomRuleListResponse>?
        get() = javaResource.customRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customRuleListResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describes Azure CDN endpoints associated with this Web Application Firewall policy.
     */
    public val endpointLinks: Output<List<CdnEndpointResponse>>
        get() = javaResource.endpointLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cdnEndpointResponseToKotlin(args0) })
            })
        })

    /**
     * Gets a unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-Value pair representing additional properties for Web Application Firewall policy.
     */
    public val extendedProperties: Output<Map<String, String>>?
        get() = javaResource.extendedProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Describes managed rules inside the policy.
     */
    public val managedRules: Output<ManagedRuleSetListResponse>?
        get() = javaResource.managedRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedRuleSetListResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Describes  policySettings for policy
     */
    public val policySettings: Output<PolicySettingsResponse>?
        get() = javaResource.policySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policySettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Provisioning state of the WebApplicationFirewallPolicy.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Describes rate limit rules inside the policy.
     */
    public val rateLimitRules: Output<RateLimitRuleListResponse>?
        get() = javaResource.rateLimitRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> rateLimitRuleListResponseToKotlin(args0) })
            }).orElse(null)
        })

    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.azurenative.cdn.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
