@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.RouteArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.AFDEndpointProtocols
import com.pulumi.azurenative.cdn.kotlin.enums.EnabledState
import com.pulumi.azurenative.cdn.kotlin.enums.ForwardingProtocol
import com.pulumi.azurenative.cdn.kotlin.enums.HttpsRedirect
import com.pulumi.azurenative.cdn.kotlin.enums.LinkToDefaultDomain
import com.pulumi.azurenative.cdn.kotlin.inputs.ActivatedResourceReferenceArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ActivatedResourceReferenceArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.AfdRouteCacheConfigurationArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.AfdRouteCacheConfigurationArgsBuilder
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Friendly Routes name mapping to the any Routes or secret related information.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2020-09-01, 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Routes_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var route = new AzureNative.Cdn.Route("route", new()
 *     {
 *         CacheConfiguration = new AzureNative.Cdn.Inputs.AfdRouteCacheConfigurationArgs
 *         {
 *             CompressionSettings = new AzureNative.Cdn.Inputs.CompressionSettingsArgs
 *             {
 *                 ContentTypesToCompress = new[]
 *                 {
 *                     "text/html",
 *                     "application/octet-stream",
 *                 },
 *                 IsCompressionEnabled = true,
 *             },
 *             QueryParameters = "querystring=test",
 *             QueryStringCachingBehavior = AzureNative.Cdn.AfdQueryStringCachingBehavior.IgnoreSpecifiedQueryStrings,
 *         },
 *         CustomDomains = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.ActivatedResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/customDomains/domain1",
 *             },
 *         },
 *         EnabledState = AzureNative.Cdn.EnabledState.Enabled,
 *         EndpointName = "endpoint1",
 *         ForwardingProtocol = AzureNative.Cdn.ForwardingProtocol.MatchRequest,
 *         HttpsRedirect = AzureNative.Cdn.HttpsRedirect.Enabled,
 *         LinkToDefaultDomain = AzureNative.Cdn.LinkToDefaultDomain.Enabled,
 *         OriginGroup = new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/originGroups/originGroup1",
 *         },
 *         PatternsToMatch = new[]
 *         {
 *             "/*",
 *         },
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         RouteName = "route1",
 *         RuleSets = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/ruleSets/ruleSet1",
 *             },
 *         },
 *         SupportedProtocols = new[]
 *         {
 *             AzureNative.Cdn.AFDEndpointProtocols.Https,
 *             AzureNative.Cdn.AFDEndpointProtocols.Http,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewRoute(ctx, "route", &cdn.RouteArgs{
 * 			CacheConfiguration: &cdn.AfdRouteCacheConfigurationArgs{
 * 				CompressionSettings: &cdn.CompressionSettingsArgs{
 * 					ContentTypesToCompress: pulumi.StringArray{
 * 						pulumi.String("text/html"),
 * 						pulumi.String("application/octet-stream"),
 * 					},
 * 					IsCompressionEnabled: pulumi.Bool(true),
 * 				},
 * 				QueryParameters:            pulumi.String("querystring=test"),
 * 				QueryStringCachingBehavior: pulumi.String(cdn.AfdQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings),
 * 			},
 * 			CustomDomains: cdn.ActivatedResourceReferenceArray{
 * 				&cdn.ActivatedResourceReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/customDomains/domain1"),
 * 				},
 * 			},
 * 			EnabledState:        pulumi.String(cdn.EnabledStateEnabled),
 * 			EndpointName:        pulumi.String("endpoint1"),
 * 			ForwardingProtocol:  pulumi.String(cdn.ForwardingProtocolMatchRequest),
 * 			HttpsRedirect:       pulumi.String(cdn.HttpsRedirectEnabled),
 * 			LinkToDefaultDomain: pulumi.String(cdn.LinkToDefaultDomainEnabled),
 * 			OriginGroup: &cdn.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/originGroups/originGroup1"),
 * 			},
 * 			PatternsToMatch: pulumi.StringArray{
 * 				pulumi.String("/*"),
 * 			},
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			RouteName:         pulumi.String("route1"),
 * 			RuleSets: cdn.ResourceReferenceArray{
 * 				&cdn.ResourceReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/ruleSets/ruleSet1"),
 * 				},
 * 			},
 * 			SupportedProtocols: pulumi.StringArray{
 * 				pulumi.String(cdn.AFDEndpointProtocolsHttps),
 * 				pulumi.String(cdn.AFDEndpointProtocolsHttp),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Route;
 * import com.pulumi.azurenative.cdn.RouteArgs;
 * import com.pulumi.azurenative.cdn.inputs.AfdRouteCacheConfigurationArgs;
 * import com.pulumi.azurenative.cdn.inputs.CompressionSettingsArgs;
 * import com.pulumi.azurenative.cdn.inputs.ActivatedResourceReferenceArgs;
 * import com.pulumi.azurenative.cdn.inputs.ResourceReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var route = new Route("route", RouteArgs.builder()
 *             .cacheConfiguration(AfdRouteCacheConfigurationArgs.builder()
 *                 .compressionSettings(CompressionSettingsArgs.builder()
 *                     .contentTypesToCompress(
 *                         "text/html",
 *                         "application/octet-stream")
 *                     .isCompressionEnabled(true)
 *                     .build())
 *                 .queryParameters("querystring=test")
 *                 .queryStringCachingBehavior("IgnoreSpecifiedQueryStrings")
 *                 .build())
 *             .customDomains(ActivatedResourceReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/customDomains/domain1")
 *                 .build())
 *             .enabledState("Enabled")
 *             .endpointName("endpoint1")
 *             .forwardingProtocol("MatchRequest")
 *             .httpsRedirect("Enabled")
 *             .linkToDefaultDomain("Enabled")
 *             .originGroup(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/originGroups/originGroup1")
 *                 .build())
 *             .patternsToMatch("/*")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .routeName("route1")
 *             .ruleSets(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/ruleSets/ruleSet1")
 *                 .build())
 *             .supportedProtocols(
 *                 "Https",
 *                 "Http")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Route route1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}
 * ```
 * @property cacheConfiguration The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
 * @property customDomains Domains referenced by this endpoint.
 * @property enabledState Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property forwardingProtocol Protocol this rule will use when forwarding traffic to backends.
 * @property httpsRedirect Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed.
 * @property linkToDefaultDomain whether this route will be linked to the default endpoint domain.
 * @property originGroup A reference to the origin group.
 * @property originPath A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
 * @property patternsToMatch The route patterns of the rule.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property routeName Name of the routing rule.
 * @property ruleSets rule sets referenced by this endpoint.
 * @property supportedProtocols List of supported protocols for this route.
 * */*/*/
 */
public data class RouteArgs(
    public val cacheConfiguration: Output<AfdRouteCacheConfigurationArgs>? = null,
    public val customDomains: Output<List<ActivatedResourceReferenceArgs>>? = null,
    public val enabledState: Output<Either<String, EnabledState>>? = null,
    public val endpointName: Output<String>? = null,
    public val forwardingProtocol: Output<Either<String, ForwardingProtocol>>? = null,
    public val httpsRedirect: Output<Either<String, HttpsRedirect>>? = null,
    public val linkToDefaultDomain: Output<Either<String, LinkToDefaultDomain>>? = null,
    public val originGroup: Output<ResourceReferenceArgs>? = null,
    public val originPath: Output<String>? = null,
    public val patternsToMatch: Output<List<String>>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeName: Output<String>? = null,
    public val ruleSets: Output<List<ResourceReferenceArgs>>? = null,
    public val supportedProtocols: Output<List<Either<String, AFDEndpointProtocols>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.RouteArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.RouteArgs =
        com.pulumi.azurenative.cdn.RouteArgs.builder()
            .cacheConfiguration(
                cacheConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customDomains(
                customDomains?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .forwardingProtocol(
                forwardingProtocol?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .httpsRedirect(
                httpsRedirect?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .linkToDefaultDomain(
                linkToDefaultDomain?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .originGroup(originGroup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .originPath(originPath?.applyValue({ args0 -> args0 }))
            .patternsToMatch(patternsToMatch?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeName(routeName?.applyValue({ args0 -> args0 }))
            .ruleSets(
                ruleSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .supportedProtocols(
                supportedProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var cacheConfiguration: Output<AfdRouteCacheConfigurationArgs>? = null

    private var customDomains: Output<List<ActivatedResourceReferenceArgs>>? = null

    private var enabledState: Output<Either<String, EnabledState>>? = null

    private var endpointName: Output<String>? = null

    private var forwardingProtocol: Output<Either<String, ForwardingProtocol>>? = null

    private var httpsRedirect: Output<Either<String, HttpsRedirect>>? = null

    private var linkToDefaultDomain: Output<Either<String, LinkToDefaultDomain>>? = null

    private var originGroup: Output<ResourceReferenceArgs>? = null

    private var originPath: Output<String>? = null

    private var patternsToMatch: Output<List<String>>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeName: Output<String>? = null

    private var ruleSets: Output<List<ResourceReferenceArgs>>? = null

    private var supportedProtocols: Output<List<Either<String, AFDEndpointProtocols>>>? = null

    /**
     * @param value The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
     */
    @JvmName("yggxnruwqlnjahfk")
    public suspend fun cacheConfiguration(`value`: Output<AfdRouteCacheConfigurationArgs>) {
        this.cacheConfiguration = value
    }

    /**
     * @param value Domains referenced by this endpoint.
     */
    @JvmName("jwyhftvpbgtofqho")
    public suspend fun customDomains(`value`: Output<List<ActivatedResourceReferenceArgs>>) {
        this.customDomains = value
    }

    @JvmName("nksaickbrnqtxkpu")
    public suspend fun customDomains(vararg values: Output<ActivatedResourceReferenceArgs>) {
        this.customDomains = Output.all(values.asList())
    }

    /**
     * @param values Domains referenced by this endpoint.
     */
    @JvmName("ecuvfffasatmpesb")
    public suspend fun customDomains(values: List<Output<ActivatedResourceReferenceArgs>>) {
        this.customDomains = Output.all(values)
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("riwdieaesrfefcdm")
    public suspend fun enabledState(`value`: Output<Either<String, EnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("fqgmxbrvlxxjlpjl")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("dlibhmejmhqdqhlt")
    public suspend fun forwardingProtocol(`value`: Output<Either<String, ForwardingProtocol>>) {
        this.forwardingProtocol = value
    }

    /**
     * @param value Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed.
     */
    @JvmName("hmrjafvkqwsbcyuc")
    public suspend fun httpsRedirect(`value`: Output<Either<String, HttpsRedirect>>) {
        this.httpsRedirect = value
    }

    /**
     * @param value whether this route will be linked to the default endpoint domain.
     */
    @JvmName("fvrwkgxpqaniqvof")
    public suspend fun linkToDefaultDomain(`value`: Output<Either<String, LinkToDefaultDomain>>) {
        this.linkToDefaultDomain = value
    }

    /**
     * @param value A reference to the origin group.
     */
    @JvmName("eleqagislitrasim")
    public suspend fun originGroup(`value`: Output<ResourceReferenceArgs>) {
        this.originGroup = value
    }

    /**
     * @param value A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
     */
    @JvmName("xbqxhtyinkadqloc")
    public suspend fun originPath(`value`: Output<String>) {
        this.originPath = value
    }

    /**
     * @param value The route patterns of the rule.
     */
    @JvmName("ukvkkplbkdfjgson")
    public suspend fun patternsToMatch(`value`: Output<List<String>>) {
        this.patternsToMatch = value
    }

    @JvmName("ftsppoaeeeiphsdv")
    public suspend fun patternsToMatch(vararg values: Output<String>) {
        this.patternsToMatch = Output.all(values.asList())
    }

    /**
     * @param values The route patterns of the rule.
     */
    @JvmName("aalvhaidnwuybhng")
    public suspend fun patternsToMatch(values: List<Output<String>>) {
        this.patternsToMatch = Output.all(values)
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("txxjrbnblbmtckip")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("ycdffklvjjpmcuce")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the routing rule.
     */
    @JvmName("hiaynvohkxnvondl")
    public suspend fun routeName(`value`: Output<String>) {
        this.routeName = value
    }

    /**
     * @param value rule sets referenced by this endpoint.
     */
    @JvmName("oewsjabhpoktqjue")
    public suspend fun ruleSets(`value`: Output<List<ResourceReferenceArgs>>) {
        this.ruleSets = value
    }

    @JvmName("cjnnntyqnmpcwjok")
    public suspend fun ruleSets(vararg values: Output<ResourceReferenceArgs>) {
        this.ruleSets = Output.all(values.asList())
    }

    /**
     * @param values rule sets referenced by this endpoint.
     */
    @JvmName("lrpmrgmlygdxlmmx")
    public suspend fun ruleSets(values: List<Output<ResourceReferenceArgs>>) {
        this.ruleSets = Output.all(values)
    }

    /**
     * @param value List of supported protocols for this route.
     */
    @JvmName("odtwnktggpjssohf")
    public suspend fun supportedProtocols(`value`: Output<List<Either<String, AFDEndpointProtocols>>>) {
        this.supportedProtocols = value
    }

    @JvmName("rbygnorncxknlmja")
    public suspend fun supportedProtocols(vararg values: Output<Either<String, AFDEndpointProtocols>>) {
        this.supportedProtocols = Output.all(values.asList())
    }

    /**
     * @param values List of supported protocols for this route.
     */
    @JvmName("fswywqiqvstnfgbj")
    public suspend fun supportedProtocols(values: List<Output<Either<String, AFDEndpointProtocols>>>) {
        this.supportedProtocols = Output.all(values)
    }

    /**
     * @param value The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
     */
    @JvmName("dlcuoqstayywgcbq")
    public suspend fun cacheConfiguration(`value`: AfdRouteCacheConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheConfiguration = mapped
    }

    /**
     * @param argument The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
     */
    @JvmName("yfptqmdhsrewfxxt")
    public suspend fun cacheConfiguration(argument: suspend AfdRouteCacheConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AfdRouteCacheConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cacheConfiguration = mapped
    }

    /**
     * @param value Domains referenced by this endpoint.
     */
    @JvmName("lnuaxaokrrxfxecl")
    public suspend fun customDomains(`value`: List<ActivatedResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomains = mapped
    }

    /**
     * @param argument Domains referenced by this endpoint.
     */
    @JvmName("lecedbvlrhhqjnos")
    public suspend fun customDomains(argument: List<suspend ActivatedResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivatedResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customDomains = mapped
    }

    /**
     * @param argument Domains referenced by this endpoint.
     */
    @JvmName("iplgeifdoswggauj")
    public suspend fun customDomains(vararg argument: suspend ActivatedResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivatedResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customDomains = mapped
    }

    /**
     * @param argument Domains referenced by this endpoint.
     */
    @JvmName("llqtfsaftcineaku")
    public suspend fun customDomains(argument: suspend ActivatedResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ActivatedResourceReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customDomains = mapped
    }

    /**
     * @param values Domains referenced by this endpoint.
     */
    @JvmName("dmnehykfktpcipty")
    public suspend fun customDomains(vararg values: ActivatedResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDomains = mapped
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("nmqbpdagmatfoaad")
    public suspend fun enabledState(`value`: Either<String, EnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("ikgejohyduwyrvlm")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("frxutiumiaqsoxul")
    public fun enabledState(`value`: EnabledState) {
        val toBeMapped = Either.ofRight<String, EnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("cisnlunblqgxqgia")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("cthtdibcfammmnmg")
    public suspend fun forwardingProtocol(`value`: Either<String, ForwardingProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardingProtocol = mapped
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("oamcejiijjroqanr")
    public fun forwardingProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ForwardingProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardingProtocol = mapped
    }

    /**
     * @param value Protocol this rule will use when forwarding traffic to backends.
     */
    @JvmName("eopsohlywashgpfk")
    public fun forwardingProtocol(`value`: ForwardingProtocol) {
        val toBeMapped = Either.ofRight<String, ForwardingProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardingProtocol = mapped
    }

    /**
     * @param value Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed.
     */
    @JvmName("afisawmbdiaajpye")
    public suspend fun httpsRedirect(`value`: Either<String, HttpsRedirect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsRedirect = mapped
    }

    /**
     * @param value Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed.
     */
    @JvmName("xmrlufwmwnqmnkbj")
    public fun httpsRedirect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HttpsRedirect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpsRedirect = mapped
    }

    /**
     * @param value Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed.
     */
    @JvmName("xitmwkjtuyhxqkos")
    public fun httpsRedirect(`value`: HttpsRedirect) {
        val toBeMapped = Either.ofRight<String, HttpsRedirect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpsRedirect = mapped
    }

    /**
     * @param value whether this route will be linked to the default endpoint domain.
     */
    @JvmName("xuntbaouobbuhqdq")
    public suspend fun linkToDefaultDomain(`value`: Either<String, LinkToDefaultDomain>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkToDefaultDomain = mapped
    }

    /**
     * @param value whether this route will be linked to the default endpoint domain.
     */
    @JvmName("rtwftxfoyxjtynby")
    public fun linkToDefaultDomain(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LinkToDefaultDomain>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkToDefaultDomain = mapped
    }

    /**
     * @param value whether this route will be linked to the default endpoint domain.
     */
    @JvmName("dxktvyjrwnqalcls")
    public fun linkToDefaultDomain(`value`: LinkToDefaultDomain) {
        val toBeMapped = Either.ofRight<String, LinkToDefaultDomain>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkToDefaultDomain = mapped
    }

    /**
     * @param value A reference to the origin group.
     */
    @JvmName("smqbsviydhiioghi")
    public suspend fun originGroup(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originGroup = mapped
    }

    /**
     * @param argument A reference to the origin group.
     */
    @JvmName("qruilfdglqxxoias")
    public suspend fun originGroup(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.originGroup = mapped
    }

    /**
     * @param value A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
     */
    @JvmName("kshlwcplxxbpjpts")
    public suspend fun originPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originPath = mapped
    }

    /**
     * @param value The route patterns of the rule.
     */
    @JvmName("lnscwhmqvpbhlfcr")
    public suspend fun patternsToMatch(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patternsToMatch = mapped
    }

    /**
     * @param values The route patterns of the rule.
     */
    @JvmName("psgqnbvbwmtsubce")
    public suspend fun patternsToMatch(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patternsToMatch = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("nmtpbnxkcgvfaclw")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("dkebgllpsdnancap")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the routing rule.
     */
    @JvmName("usngmrutxucjkeyt")
    public suspend fun routeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeName = mapped
    }

    /**
     * @param value rule sets referenced by this endpoint.
     */
    @JvmName("sbhmncfpqmtrtcmy")
    public suspend fun ruleSets(`value`: List<ResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSets = mapped
    }

    /**
     * @param argument rule sets referenced by this endpoint.
     */
    @JvmName("yfyyhyrrnulwokil")
    public suspend fun ruleSets(argument: List<suspend ResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleSets = mapped
    }

    /**
     * @param argument rule sets referenced by this endpoint.
     */
    @JvmName("okbhapipbdrsqmtq")
    public suspend fun ruleSets(vararg argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleSets = mapped
    }

    /**
     * @param argument rule sets referenced by this endpoint.
     */
    @JvmName("ytqcqbcutviwnich")
    public suspend fun ruleSets(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ruleSets = mapped
    }

    /**
     * @param values rule sets referenced by this endpoint.
     */
    @JvmName("epjrrnngueqkbkbf")
    public suspend fun ruleSets(vararg values: ResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSets = mapped
    }

    /**
     * @param value List of supported protocols for this route.
     */
    @JvmName("najacuancgqrfrkf")
    public suspend fun supportedProtocols(`value`: List<Either<String, AFDEndpointProtocols>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedProtocols = mapped
    }

    /**
     * @param values List of supported protocols for this route.
     */
    @JvmName("jfwsiisesxgshuem")
    public suspend fun supportedProtocols(vararg values: Either<String, AFDEndpointProtocols>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportedProtocols = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        cacheConfiguration = cacheConfiguration,
        customDomains = customDomains,
        enabledState = enabledState,
        endpointName = endpointName,
        forwardingProtocol = forwardingProtocol,
        httpsRedirect = httpsRedirect,
        linkToDefaultDomain = linkToDefaultDomain,
        originGroup = originGroup,
        originPath = originPath,
        patternsToMatch = patternsToMatch,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        routeName = routeName,
        ruleSets = ruleSets,
        supportedProtocols = supportedProtocols,
    )
}
