@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Secret].
 */
@PulumiTagMarker
public class SecretResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretArgs = SecretArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretArgsBuilder.() -> Unit) {
        val builder = SecretArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Secret {
        val builtJavaResource = com.pulumi.azurenative.cdn.Secret(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Secret(builtJavaResource)
    }
}

/**
 * Friendly Secret name mapping to the any Secret or secret related information.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Secrets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var secret = new AzureNative.Cdn.Secret("secret", new()
 *     {
 *         Parameters = new AzureNative.Cdn.Inputs.CustomerCertificateParametersArgs
 *         {
 *             SecretSource = new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.KeyVault/vault/kvName/secrets/certificatename",
 *             },
 *             SecretVersion = "abcdef1234578900abcdef1234567890",
 *             Type = "CustomerCertificate",
 *             UseLatestVersion = false,
 *         },
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         SecretName = "secret1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewSecret(ctx, "secret", &cdn.SecretArgs{
 * 			Parameters: cdn.CustomerCertificateParameters{
 * 				SecretSource: cdn.ResourceReference{
 * 					Id: "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.KeyVault/vault/kvName/secrets/certificatename",
 * 				},
 * 				SecretVersion:    "abcdef1234578900abcdef1234567890",
 * 				Type:             "CustomerCertificate",
 * 				UseLatestVersion: false,
 * 			},
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			SecretName:        pulumi.String("secret1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Secret;
 * import com.pulumi.azurenative.cdn.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secret = new Secret("secret", SecretArgs.builder()
 *             .parameters(CustomerCertificateParametersArgs.builder()
 *                 .secretSource(ResourceReferenceArgs.builder()
 *                     .id("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.KeyVault/vault/kvName/secrets/certificatename")
 *                     .build())
 *                 .secretVersion("abcdef1234578900abcdef1234567890")
 *                 .type("CustomerCertificate")
 *                 .useLatestVersion(false)
 *                 .build())
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .secretName("secret1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Secret secret1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}
 * ```
 */
public class Secret internal constructor(
    override val javaResource: com.pulumi.azurenative.cdn.Secret,
) : KotlinCustomResource(javaResource, SecretMapper) {
    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * object which contains secret parameters
     */
    public val parameters: Output<Any>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the profile which holds the secret.
     */
    public val profileName: Output<String>
        get() = javaResource.profileName().applyValue({ args0 -> args0 })

    /**
     * Provisioning status
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecretMapper : ResourceMapper<Secret> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cdn.Secret::class == javaResource::class

    override fun map(javaResource: Resource): Secret = Secret(
        javaResource as
            com.pulumi.azurenative.cdn.Secret,
    )
}

/**
 * @see [Secret].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Secret].
 */
public suspend fun secret(name: String, block: suspend SecretResourceBuilder.() -> Unit): Secret {
    val builder = SecretResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Secret].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secret(name: String): Secret {
    val builder = SecretResourceBuilder()
    builder.name(name)
    return builder.build()
}
