@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.SecretArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Friendly Secret name mapping to the any Secret or secret related information.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Secrets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var secret = new AzureNative.Cdn.Secret("secret", new()
 *     {
 *         Parameters = new AzureNative.Cdn.Inputs.CustomerCertificateParametersArgs
 *         {
 *             SecretSource = new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.KeyVault/vault/kvName/secrets/certificatename",
 *             },
 *             SecretVersion = "abcdef1234578900abcdef1234567890",
 *             Type = "CustomerCertificate",
 *             UseLatestVersion = false,
 *         },
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         SecretName = "secret1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewSecret(ctx, "secret", &cdn.SecretArgs{
 * 			Parameters: cdn.CustomerCertificateParameters{
 * 				SecretSource: cdn.ResourceReference{
 * 					Id: "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.KeyVault/vault/kvName/secrets/certificatename",
 * 				},
 * 				SecretVersion:    "abcdef1234578900abcdef1234567890",
 * 				Type:             "CustomerCertificate",
 * 				UseLatestVersion: false,
 * 			},
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			SecretName:        pulumi.String("secret1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Secret;
 * import com.pulumi.azurenative.cdn.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secret = new Secret("secret", SecretArgs.builder()
 *             .parameters(CustomerCertificateParametersArgs.builder()
 *                 .secretSource(ResourceReferenceArgs.builder()
 *                     .id("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.KeyVault/vault/kvName/secrets/certificatename")
 *                     .build())
 *                 .secretVersion("abcdef1234578900abcdef1234567890")
 *                 .type("CustomerCertificate")
 *                 .useLatestVersion(false)
 *                 .build())
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .secretName("secret1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Secret secret1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}
 * ```
 * @property parameters object which contains secret parameters
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property secretName Name of the Secret under the profile.
 */
public data class SecretArgs(
    public val parameters: Output<Any>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.SecretArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.SecretArgs =
        com.pulumi.azurenative.cdn.SecretArgs.builder()
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretName(secretName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretArgs].
 */
@PulumiTagMarker
public class SecretArgsBuilder internal constructor() {
    private var parameters: Output<Any>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretName: Output<String>? = null

    /**
     * @param value object which contains secret parameters
     */
    @JvmName("wayijvcycuyamljq")
    public suspend fun parameters(`value`: Output<Any>) {
        this.parameters = value
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("vussnfsmrgqpaggf")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("lamviyjjrxcfqdda")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the Secret under the profile.
     */
    @JvmName("lycaqbcsbwsmmoap")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value object which contains secret parameters
     */
    @JvmName("ddrcsklhrnxihbwp")
    public suspend fun parameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("anumetawwyarxfuf")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("mfwxahlogiasejsm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Secret under the profile.
     */
    @JvmName("xhowjplxasbngwfe")
    public suspend fun secretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    internal fun build(): SecretArgs = SecretArgs(
        parameters = parameters,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        secretName = secretName,
    )
}
