@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.SecurityPolicyArgs.builder
import com.pulumi.azurenative.cdn.kotlin.inputs.SecurityPolicyWebApplicationFirewallParametersArgs
import com.pulumi.azurenative.cdn.kotlin.inputs.SecurityPolicyWebApplicationFirewallParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * SecurityPolicy association for AzureFrontDoor profile
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview, 2024-02-01.
 * ## Example Usage
 * ### SecurityPolicies_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityPolicy = new AzureNative.Cdn.SecurityPolicy("securityPolicy", new()
 *     {
 *         Parameters = new AzureNative.Cdn.Inputs.SecurityPolicyWebApplicationFirewallParametersArgs
 *         {
 *             Associations = new[]
 *             {
 *                 new AzureNative.Cdn.Inputs.SecurityPolicyWebApplicationFirewallAssociationArgs
 *                 {
 *                     Domains = new[]
 *                     {
 *                         new AzureNative.Cdn.Inputs.ActivatedResourceReferenceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain1",
 *                         },
 *                         new AzureNative.Cdn.Inputs.ActivatedResourceReferenceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain2",
 *                         },
 *                     },
 *                     PatternsToMatch = new[]
 *                     {
 *                         "/*",
 *                     },
 *                 },
 *             },
 *             Type = "WebApplicationFirewall",
 *             WafPolicy = new AzureNative.Cdn.Inputs.ResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Network/frontdoorwebapplicationfirewallpolicies/wafTest",
 *             },
 *         },
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         SecurityPolicyName = "securityPolicy1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewSecurityPolicy(ctx, "securityPolicy", &cdn.SecurityPolicyArgs{
 * 			Parameters: &cdn.SecurityPolicyWebApplicationFirewallParametersArgs{
 * 				Associations: cdn.SecurityPolicyWebApplicationFirewallAssociationArray{
 * 					&cdn.SecurityPolicyWebApplicationFirewallAssociationArgs{
 * 						Domains: cdn.ActivatedResourceReferenceArray{
 * 							&cdn.ActivatedResourceReferenceArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain1"),
 * 							},
 * 							&cdn.ActivatedResourceReferenceArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain2"),
 * 							},
 * 						},
 * 						PatternsToMatch: pulumi.StringArray{
 * 							pulumi.String("/*"),
 * 						},
 * 					},
 * 				},
 * 				Type: pulumi.String("WebApplicationFirewall"),
 * 				WafPolicy: &cdn.ResourceReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Network/frontdoorwebapplicationfirewallpolicies/wafTest"),
 * 				},
 * 			},
 * 			ProfileName:        pulumi.String("profile1"),
 * 			ResourceGroupName:  pulumi.String("RG"),
 * 			SecurityPolicyName: pulumi.String("securityPolicy1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.SecurityPolicy;
 * import com.pulumi.azurenative.cdn.SecurityPolicyArgs;
 * import com.pulumi.azurenative.cdn.inputs.SecurityPolicyWebApplicationFirewallParametersArgs;
 * import com.pulumi.azurenative.cdn.inputs.ResourceReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityPolicy = new SecurityPolicy("securityPolicy", SecurityPolicyArgs.builder()
 *             .parameters(SecurityPolicyWebApplicationFirewallParametersArgs.builder()
 *                 .associations(SecurityPolicyWebApplicationFirewallAssociationArgs.builder()
 *                     .domains(
 *                         ActivatedResourceReferenceArgs.builder()
 *                             .id("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain1")
 *                             .build(),
 *                         ActivatedResourceReferenceArgs.builder()
 *                             .id("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/customdomains/testdomain2")
 *                             .build())
 *                     .patternsToMatch("/*")
 *                     .build())
 *                 .type("WebApplicationFirewall")
 *                 .wafPolicy(ResourceReferenceArgs.builder()
 *                     .id("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Network/frontdoorwebapplicationfirewallpolicies/wafTest")
 *                     .build())
 *                 .build())
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .securityPolicyName("securityPolicy1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:SecurityPolicy securityPolicy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}
 * ```
 * @property parameters object which contains security policy parameters
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property securityPolicyName Name of the security policy under the profile.
 * */*/*/
 */
public data class SecurityPolicyArgs(
    public val parameters: Output<SecurityPolicyWebApplicationFirewallParametersArgs>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityPolicyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.SecurityPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.SecurityPolicyArgs =
        com.pulumi.azurenative.cdn.SecurityPolicyArgs.builder()
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityPolicyName(securityPolicyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityPolicyArgs].
 */
@PulumiTagMarker
public class SecurityPolicyArgsBuilder internal constructor() {
    private var parameters: Output<SecurityPolicyWebApplicationFirewallParametersArgs>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityPolicyName: Output<String>? = null

    /**
     * @param value object which contains security policy parameters
     */
    @JvmName("ulyrgipnbonykpax")
    public suspend fun parameters(`value`: Output<SecurityPolicyWebApplicationFirewallParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("setiohjokbymvxjq")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("xqrexlyqobsrpinf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the security policy under the profile.
     */
    @JvmName("tfebaccsrntmjegy")
    public suspend fun securityPolicyName(`value`: Output<String>) {
        this.securityPolicyName = value
    }

    /**
     * @param value object which contains security policy parameters
     */
    @JvmName("ojinbqrpfihkjsfb")
    public suspend fun parameters(`value`: SecurityPolicyWebApplicationFirewallParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument object which contains security policy parameters
     */
    @JvmName("ufadwiawcfsubnci")
    public suspend fun parameters(argument: suspend SecurityPolicyWebApplicationFirewallParametersArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityPolicyWebApplicationFirewallParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("bmsktlilvenovoeb")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("wciwkmbdejuaedvl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the security policy under the profile.
     */
    @JvmName("wlugoqxbgeaajqfu")
    public suspend fun securityPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicyName = mapped
    }

    internal fun build(): SecurityPolicyArgs = SecurityPolicyArgs(
        parameters = parameters,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        securityPolicyName = securityPolicyName,
    )
}
