@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
 */
public enum class AfdQueryStringCachingBehavior(
    public val javaValue: com.pulumi.azurenative.cdn.enums.AfdQueryStringCachingBehavior,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.AfdQueryStringCachingBehavior> {
    IgnoreQueryString(com.pulumi.azurenative.cdn.enums.AfdQueryStringCachingBehavior.IgnoreQueryString),
    UseQueryString(com.pulumi.azurenative.cdn.enums.AfdQueryStringCachingBehavior.UseQueryString),
    IgnoreSpecifiedQueryStrings(com.pulumi.azurenative.cdn.enums.AfdQueryStringCachingBehavior.IgnoreSpecifiedQueryStrings),
    IncludeSpecifiedQueryStrings(com.pulumi.azurenative.cdn.enums.AfdQueryStringCachingBehavior.IncludeSpecifiedQueryStrings),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.AfdQueryStringCachingBehavior = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.AfdQueryStringCachingBehavior): AfdQueryStringCachingBehavior =
            AfdQueryStringCachingBehavior.values().first { it.javaValue == javaType }
    }
}
