@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Protocol to use for the redirect. The default value is MatchRequest
 */
public enum class DestinationProtocol(
    public val javaValue: com.pulumi.azurenative.cdn.enums.DestinationProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.DestinationProtocol> {
    MatchRequest(com.pulumi.azurenative.cdn.enums.DestinationProtocol.MatchRequest),
    Http(com.pulumi.azurenative.cdn.enums.DestinationProtocol.Http),
    Https(com.pulumi.azurenative.cdn.enums.DestinationProtocol.Https),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.DestinationProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.DestinationProtocol): DestinationProtocol = DestinationProtocol.values().first { it.javaValue == javaType }
    }
}
