@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
 */
public enum class ManagedRuleEnabledState(
    public val javaValue: com.pulumi.azurenative.cdn.enums.ManagedRuleEnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.ManagedRuleEnabledState> {
    Disabled(com.pulumi.azurenative.cdn.enums.ManagedRuleEnabledState.Disabled),
    Enabled(com.pulumi.azurenative.cdn.enums.ManagedRuleEnabledState.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.ManagedRuleEnabledState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.ManagedRuleEnabledState): ManagedRuleEnabledState =
            ManagedRuleEnabledState.values().first { it.javaValue == javaType }
    }
}
