@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL.
 */
public enum class QueryStringCachingBehavior(
    public val javaValue: com.pulumi.azurenative.cdn.enums.QueryStringCachingBehavior,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.QueryStringCachingBehavior> {
    IgnoreQueryString(com.pulumi.azurenative.cdn.enums.QueryStringCachingBehavior.IgnoreQueryString),
    BypassCaching(com.pulumi.azurenative.cdn.enums.QueryStringCachingBehavior.BypassCaching),
    UseQueryString(com.pulumi.azurenative.cdn.enums.QueryStringCachingBehavior.UseQueryString),
    NotSet(com.pulumi.azurenative.cdn.enums.QueryStringCachingBehavior.NotSet),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.QueryStringCachingBehavior = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.QueryStringCachingBehavior): QueryStringCachingBehavior =
            QueryStringCachingBehavior.values().first { it.javaValue == javaType }
    }
}
